/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rabc.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;
import top.verytouch.vkit.common.base.ApiCode;
import top.verytouch.vkit.common.base.Response;
import top.verytouch.vkit.common.exception.AssertException;
import top.verytouch.vkit.common.exception.BusinessException;

@ControllerAdvice
@ResponseBody
public class RestControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(RestControllerAdvice.class);

    @ExceptionHandler(value={AssertException.class})
    public Response<String> assertException(Exception e) {
        return this.error(ApiCode.PARAM_ERROR, e, false);
    }

    @ExceptionHandler(value={BusinessException.class})
    public Response<String> businessException(Exception e) {
        return this.error(ApiCode.PARAM_ERROR, e, false);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Response<String> nullPointerException(Exception e) {
        return this.error(ApiCode.PARAM_ABSENT, e, true);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Response<String> authenticationException(AuthenticationException e) {
        return this.error(ApiCode.SYS_UNAUTHENTICATED);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Response<String> accessDeniedException(AccessDeniedException e) {
        return this.error(ApiCode.SYS_FORBIDDEN);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Response<String> noHandlerFoundException(NoHandlerFoundException e) {
        return this.error(ApiCode.SYS_NO_HANDLER);
    }

    @ExceptionHandler(value={Exception.class})
    public Response<String> exception(Exception e) {
        return this.error(ApiCode.ERROR, e, true);
    }

    private Response<String> error(ApiCode code, Exception e, boolean printLog) {
        if (printLog) {
            log.error(code.getDesc(), (Throwable)e);
        }
        String msg = e instanceof AssertException ? e.getMessage() : code.getDesc();
        return Response.error((int)code.getCode(), (String)msg);
    }

    private Response<String> error(ApiCode code) {
        return Response.error((int)code.getCode(), (String)code.getDesc());
    }
}

