/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.captcha.tencent;

import com.tencentcloudapi.captcha.v20190722.CaptchaClient;
import com.tencentcloudapi.captcha.v20190722.models.DescribeCaptchaResultRequest;
import com.tencentcloudapi.captcha.v20190722.models.DescribeCaptchaResultResponse;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.captcha.CaptchaEnum;
import top.verytouch.vkit.captcha.CaptchaParams;
import top.verytouch.vkit.captcha.CaptchaService;
import top.verytouch.vkit.captcha.tencent.TencentCaptchaParams;
import top.verytouch.vkit.captcha.tencent.TencentCaptchaProperties;
import top.verytouch.vkit.common.base.Assert;
import top.verytouch.vkit.common.exception.BusinessException;

public class TencentCaptchaService
implements CaptchaService {
    private static final Logger log = LoggerFactory.getLogger(TencentCaptchaService.class);
    private final CaptchaClient client;
    private final TencentCaptchaProperties properties;
    private static final Long OK_CODE = 1L;

    public TencentCaptchaService(TencentCaptchaProperties properties) {
        Credential credential = new Credential(properties.getSecretId(), properties.getSecretKey());
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint(properties.getEndpoint());
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        this.client = new CaptchaClient(credential, "", clientProfile);
        this.properties = properties;
    }

    @Override
    public CaptchaEnum getType() {
        return CaptchaEnum.TENCENT;
    }

    @Override
    public void verify(CaptchaParams params) {
        TencentCaptchaParams p = (TencentCaptchaParams)Assert.instanceOf((Object)params, TencentCaptchaParams.class, (String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u4e3aTencentCaptchaParams");
        Assert.nonBlank((String)p.getTicket(), (String)"ticket\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.nonBlank((String)p.getRandStr(), (String)"randStr\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.nonBlank((String)p.getUserIp(), (String)"userIp\u4e0d\u80fd\u4e3a\u7a7a");
        DescribeCaptchaResultRequest req = new DescribeCaptchaResultRequest();
        req.setCaptchaType(this.properties.getCaptchaType());
        req.setTicket(p.getTicket());
        req.setUserIp(p.getUserIp());
        req.setRandstr(p.getRandStr());
        req.setCaptchaAppId(this.properties.getAppId());
        req.setAppSecretKey(this.properties.getAppKey());
        try {
            DescribeCaptchaResultResponse res = this.client.DescribeCaptchaResult(req);
            if (!OK_CODE.equals(res.getCaptchaCode())) {
                throw new BusinessException(res.getCaptchaMsg());
            }
        }
        catch (Exception e) {
            log.error("\u817e\u8baf\u9a8c\u8bc1\u7801\u83b7\u53d6\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u817e\u8baf\u9a8c\u8bc1\u7801\u83b7\u53d6\u7ed3\u679c\u5931\u8d25");
        }
    }

    @Override
    public void verify(Map<String, String> params) {
        TencentCaptchaParams tencentCaptchaParams = new TencentCaptchaParams();
        tencentCaptchaParams.setTicket(params.get("ticket"));
        tencentCaptchaParams.setRandStr(params.get("randStr"));
        tencentCaptchaParams.setUserIp(params.get("userIp"));
        this.verify(tencentCaptchaParams);
    }
}

