/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.ocr.ali;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.common.exception.BusinessException;
import top.verytouch.vkit.common.util.HttpUtils;
import top.verytouch.vkit.common.util.JsonUtils;
import top.verytouch.vkit.common.util.MapUtils;
import top.verytouch.vkit.ocr.ali.AliOcrProperties;

public class AliOcrService {
    private static final Logger log = LoggerFactory.getLogger(AliOcrService.class);
    private final AliOcrProperties properties;

    public AliOcrService(AliOcrProperties properties) {
        this.properties = properties;
    }

    public String general(String img) {
        Map configure = MapUtils.Builder.hashMap().put((Object)"min_size", (Object)this.properties.getMinSize()).put((Object)"output_prob", (Object)this.properties.isOutputProb()).put((Object)"output_keypoints", (Object)this.properties.isOutputKeyPoints()).put((Object)"skip_detection", (Object)this.properties.isSkipDetection()).put((Object)"without_predicting_direction", (Object)this.properties.isWithoutPredictingDirection()).build();
        Map body = MapUtils.Builder.hashMap().put((Object)"image", (Object)img).put((Object)"configure", (Object)configure).build();
        try {
            return new HttpUtils(this.properties.getHost() + "/ocr_general").addHeader("Authorization", String.format("APPCODE %s", this.properties.getAppCode())).addHeader("Content-Type", "application/json; charset=UTF-8").body(JsonUtils.toJson((Object)body).getBytes(StandardCharsets.UTF_8)).post();
        }
        catch (Exception e) {
            log.error(String.format("\u901a\u7528OCR\u8bf7\u6c42\u5931\u8d25\uff0cimg=%s", img), (Throwable)e);
            throw new BusinessException("OCR\u8bf7\u6c42\u5931\u8d25");
        }
    }
}

