/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac;

import java.time.Duration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import top.verytouch.vkit.rbac.RbacProperties;
import top.verytouch.vkit.rbac.config.AuthorizationSererConfig;
import top.verytouch.vkit.rbac.config.ResourceServerConfig;
import top.verytouch.vkit.rbac.config.WebSecurityConfig;
import top.verytouch.vkit.rbac.oauth2.AesPasswordEncoder;
import top.verytouch.vkit.rbac.oauth2.InMemoryAuthorizationCodeService;
import top.verytouch.vkit.rbac.oauth2.JwtUserDetailsTokenEnhancer;
import top.verytouch.vkit.rbac.oauth2.LoginEvent;
import top.verytouch.vkit.rbac.oauth2.ParameterPasswordEncoder;
import top.verytouch.vkit.rbac.util.ApplicationContextUtils;
import top.verytouch.vkit.rbac.web.RestControllerAdvice;

@Configuration
@EnableConfigurationProperties(value={RbacProperties.class})
@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class, AuthorizationServerConfigurerAdapter.class, ResourceServerConfigurerAdapter.class})
@ConditionalOnProperty(prefix="vkit.rbac", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={WebSecurityConfig.class, AuthorizationSererConfig.class, ResourceServerConfig.class})
public class RbacAutoConfiguration
implements ApplicationContextAware {
    @Autowired
    private RbacProperties rbacProperties;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextUtils.init(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={ParameterPasswordEncoder.class})
    public ParameterPasswordEncoder parameterPasswordEncoder() {
        return new AesPasswordEncoder(this.rbacProperties.getParameterAesKey(), null);
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizationCodeServices.class})
    public AuthorizationCodeServices authorizationCodeServices() {
        return new InMemoryAuthorizationCodeService(Duration.ofSeconds(3L));
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtUserDetailsTokenEnhancer.class})
    public JwtUserDetailsTokenEnhancer jwtUserDetailsTokenEnhancer() {
        return userDetails -> {
            ApplicationContextUtils.publishEvent(new LoginEvent(true, userDetails, null));
            return null;
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="vkit.rbac", name={"exceptionHandlerEnabled"}, havingValue="true", matchIfMissing=true)
    public RestControllerAdvice restControllerAdvice() {
        return new RestControllerAdvice();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public CorsFilter corsFilter() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

