/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.captcha.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.captcha.CaptchaEnum;
import top.verytouch.vkit.captcha.CaptchaParams;
import top.verytouch.vkit.captcha.CaptchaService;
import top.verytouch.vkit.captcha.image.CaptchaCodeStore;
import top.verytouch.vkit.captcha.image.ImageCaptchaParams;
import top.verytouch.vkit.captcha.image.ImageCaptchaProperties;
import top.verytouch.vkit.common.base.Assert;
import top.verytouch.vkit.common.exception.BusinessException;

public class ImageCaptchaService
implements CaptchaService {
    private static final Logger log = LoggerFactory.getLogger(ImageCaptchaService.class);
    private final CaptchaCodeStore codeStore;
    public final ImageCaptchaProperties properties;

    public ImageCaptchaService(CaptchaCodeStore codeStore, ImageCaptchaProperties properties) {
        this.codeStore = codeStore;
        this.properties = properties;
    }

    @Override
    public CaptchaEnum getType() {
        return CaptchaEnum.IMAGE;
    }

    @Override
    public void verify(CaptchaParams params) {
        ImageCaptchaParams p = (ImageCaptchaParams)Assert.instanceOf((Object)params, ImageCaptchaParams.class, (String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u4e3aImageCaptchaParams");
        Assert.nonBlank((String)p.getKey(), (String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        Assert.nonBlank((String)p.getValue(), (String)("\u8bf7\u8f93\u5165" + this.properties.getLength() + "\u4f4d\u9a8c\u8bc1\u7801"));
        Assert.equalsIgnoreCase((String)p.getValue(), (String)this.codeStore.remove(p.getKey()), (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
    }

    @Override
    public void verify(Map<String, String> params) {
        ImageCaptchaParams imageCaptchaParams = new ImageCaptchaParams();
        imageCaptchaParams.setKey(params.get("key"));
        imageCaptchaParams.setValue(params.get("value"));
        this.verify(imageCaptchaParams);
    }

    public String drawAndStore(OutputStream outputStream) {
        String value = this.draw(outputStream);
        return this.codeStore.store(value, this.properties.getDefaultExpireSeconds());
    }

    public String drawAndStore(OutputStream outputStream, long expireSeconds) {
        String value = this.draw(outputStream);
        return this.codeStore.store(value, expireSeconds);
    }

    public String draw(OutputStream outputStream) {
        int i;
        Random random = new Random();
        char[] code = this.randomChar(random);
        BufferedImage image = new BufferedImage(this.properties.getWidth(), this.properties.getHeight(), 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.properties.getWidth(), this.properties.getHeight());
        graphics.setFont(new Font(this.properties.getFontName(), 1, this.properties.getFontSize()));
        int x = 10;
        for (char c : code) {
            graphics.setColor(this.randomColor(random));
            int degree = random.nextInt() % 30;
            graphics.rotate((double)degree * Math.PI / 180.0, x, 45.0);
            graphics.drawString(String.valueOf(c), x, 45);
            graphics.rotate((double)(-degree) * Math.PI / 180.0, x, 45.0);
            x += 48;
        }
        for (i = 0; i < 6; ++i) {
            graphics.setColor(this.randomColor(random));
            graphics.drawLine(random.nextInt(this.properties.getWidth()), random.nextInt(this.properties.getHeight()), random.nextInt(this.properties.getWidth()), random.nextInt(this.properties.getHeight()));
        }
        for (i = 0; i < 30; ++i) {
            int x1 = random.nextInt(this.properties.getWidth());
            int y1 = random.nextInt(this.properties.getHeight());
            graphics.setColor(this.randomColor(random));
            graphics.fillRect(x1, y1, 2, 2);
        }
        try {
            ImageIO.write((RenderedImage)image, this.properties.getSuffix(), outputStream);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u56fe\u7247\u9a8c\u8bc1\u7801\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u751f\u6210\u56fe\u7247\u9a8c\u8bc1\u7801\u5931\u8d25");
        }
        return new String(code);
    }

    private Color randomColor(Random random) {
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    private char[] randomChar(Random random) {
        char[] code = new char[this.properties.getLength()];
        String base = this.properties.getChars();
        for (int i = 0; i < code.length; ++i) {
            code[i] = base.charAt(random.nextInt(base.length()));
        }
        return code;
    }
}

