/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.oss.minio;

import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.http.Method;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.verytouch.vkit.common.exception.BusinessException;
import top.verytouch.vkit.oss.OssHelper;
import top.verytouch.vkit.oss.OssProperties;
import top.verytouch.vkit.oss.OssService;

public class MinIoService
implements OssService {
    private static final Logger log = LoggerFactory.getLogger(MinIoService.class);
    private final OssProperties properties;
    private final MinioClient client;

    public MinIoService(OssProperties properties) {
        this.properties = properties;
        this.client = MinioClient.builder().endpoint(properties.getEndpoint()).credentials(properties.getAccessId(), properties.getAccessKey()).build();
    }

    @Override
    public String upload(String bucket, String object, File file) {
        this.checkBucket(bucket);
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(object)).stream((InputStream)new FileInputStream(file), file.length(), -1L).contentType(OssHelper.getContentType(file)).build();
            this.client.putObject(args);
            return this.getPreviewUrl(bucket, object);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s\uff0cfile=%s", bucket, object, file.getName()), (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public String upload(String bucket, String object, InputStream stream, long length, String contentType) {
        this.checkBucket(bucket);
        try {
            PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(object)).stream(stream, length, -1L).contentType(contentType).build();
            this.client.putObject(args);
            return this.getPreviewUrl(bucket, object);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @Override
    public String getUploadUrl(String bucket, String object) {
        this.checkBucket(bucket);
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(bucket)).object(object)).method(Method.POST).expiry(this.properties.getUploadUrlExpireMinutes(), TimeUnit.MINUTES).build();
        try {
            return this.client.getPresignedObjectUrl(args);
        }
        catch (Exception e) {
            log.error(String.format("\u751f\u6210\u4e0a\u4f20\u94fe\u63a5\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u751f\u6210\u4e0a\u4f20\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public String getPreviewUrl(String bucket, String object) {
        return String.format("%s/%s/%s", this.properties.getEndpoint(), bucket, object);
    }

    @Override
    public InputStream download(String bucket, String object) {
        this.checkBucket(bucket);
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(object)).build();
        try {
            return this.client.getObject(args);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public void delete(String bucket, String object) {
        this.checkBucket(bucket);
        try {
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(object)).build());
        }
        catch (Exception e) {
            log.error(String.format("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0cbucket=%s\uff0cobject=%s", bucket, object), (Throwable)e);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
        }
    }

    @Override
    public void checkBucket(String bucket) {
        if (this.properties.isValidateBucket() && !this.properties.getValidBuckets().contains(bucket)) {
            throw new BusinessException("bucket " + bucket + " \u4e0d\u5408\u6cd5");
        }
    }
}

