/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac;

import java.util.Arrays;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="vkit.rbac")
@Validated
public class RbacProperties {
    private boolean enabled = true;
    @NotEmpty(message="parameterAesKey\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="parameterAesKey\u4e0d\u80fd\u4e3a\u7a7a") String parameterAesKey;
    @NotEmpty(message="jwtSingKey\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="jwtSingKey\u4e0d\u80fd\u4e3a\u7a7a") String jwtSingKey;
    private String usernameParameter = "account";
    private String passwordParameter = "password";
    private String resourceId;
    private boolean captchaEnabled = true;
    private String[] openPath;
    private Map<String, String[]> pathAnyAuthorityMapping;
    private boolean exceptionHandlerEnabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getParameterAesKey() {
        return this.parameterAesKey;
    }

    public String getJwtSingKey() {
        return this.jwtSingKey;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public String[] getOpenPath() {
        return this.openPath;
    }

    public Map<String, String[]> getPathAnyAuthorityMapping() {
        return this.pathAnyAuthorityMapping;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.exceptionHandlerEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setParameterAesKey(String parameterAesKey) {
        this.parameterAesKey = parameterAesKey;
    }

    public void setJwtSingKey(String jwtSingKey) {
        this.jwtSingKey = jwtSingKey;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setCaptchaEnabled(boolean captchaEnabled) {
        this.captchaEnabled = captchaEnabled;
    }

    public void setOpenPath(String[] openPath) {
        this.openPath = openPath;
    }

    public void setPathAnyAuthorityMapping(Map<String, String[]> pathAnyAuthorityMapping) {
        this.pathAnyAuthorityMapping = pathAnyAuthorityMapping;
    }

    public void setExceptionHandlerEnabled(boolean exceptionHandlerEnabled) {
        this.exceptionHandlerEnabled = exceptionHandlerEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbacProperties)) {
            return false;
        }
        RbacProperties other = (RbacProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$parameterAesKey = this.getParameterAesKey();
        String other$parameterAesKey = other.getParameterAesKey();
        if (this$parameterAesKey == null ? other$parameterAesKey != null : !this$parameterAesKey.equals(other$parameterAesKey)) {
            return false;
        }
        String this$jwtSingKey = this.getJwtSingKey();
        String other$jwtSingKey = other.getJwtSingKey();
        if (this$jwtSingKey == null ? other$jwtSingKey != null : !this$jwtSingKey.equals(other$jwtSingKey)) {
            return false;
        }
        String this$usernameParameter = this.getUsernameParameter();
        String other$usernameParameter = other.getUsernameParameter();
        if (this$usernameParameter == null ? other$usernameParameter != null : !this$usernameParameter.equals(other$usernameParameter)) {
            return false;
        }
        String this$passwordParameter = this.getPasswordParameter();
        String other$passwordParameter = other.getPasswordParameter();
        if (this$passwordParameter == null ? other$passwordParameter != null : !this$passwordParameter.equals(other$passwordParameter)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        if (this.isCaptchaEnabled() != other.isCaptchaEnabled()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOpenPath(), other.getOpenPath())) {
            return false;
        }
        Map<String, String[]> this$pathAnyAuthorityMapping = this.getPathAnyAuthorityMapping();
        Map<String, String[]> other$pathAnyAuthorityMapping = other.getPathAnyAuthorityMapping();
        if (this$pathAnyAuthorityMapping == null ? other$pathAnyAuthorityMapping != null : !((Object)this$pathAnyAuthorityMapping).equals(other$pathAnyAuthorityMapping)) {
            return false;
        }
        return this.isExceptionHandlerEnabled() == other.isExceptionHandlerEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbacProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $parameterAesKey = this.getParameterAesKey();
        result = result * 59 + ($parameterAesKey == null ? 43 : $parameterAesKey.hashCode());
        String $jwtSingKey = this.getJwtSingKey();
        result = result * 59 + ($jwtSingKey == null ? 43 : $jwtSingKey.hashCode());
        String $usernameParameter = this.getUsernameParameter();
        result = result * 59 + ($usernameParameter == null ? 43 : $usernameParameter.hashCode());
        String $passwordParameter = this.getPasswordParameter();
        result = result * 59 + ($passwordParameter == null ? 43 : $passwordParameter.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        result = result * 59 + (this.isCaptchaEnabled() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getOpenPath());
        Map<String, String[]> $pathAnyAuthorityMapping = this.getPathAnyAuthorityMapping();
        result = result * 59 + ($pathAnyAuthorityMapping == null ? 43 : ((Object)$pathAnyAuthorityMapping).hashCode());
        result = result * 59 + (this.isExceptionHandlerEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RbacProperties(enabled=" + this.isEnabled() + ", parameterAesKey=" + this.getParameterAesKey() + ", jwtSingKey=" + this.getJwtSingKey() + ", usernameParameter=" + this.getUsernameParameter() + ", passwordParameter=" + this.getPasswordParameter() + ", resourceId=" + this.getResourceId() + ", captchaEnabled=" + this.isCaptchaEnabled() + ", openPath=" + Arrays.deepToString(this.getOpenPath()) + ", pathAnyAuthorityMapping=" + this.getPathAnyAuthorityMapping() + ", exceptionHandlerEnabled=" + this.isExceptionHandlerEnabled() + ")";
    }
}

