/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.CompositeTokenGranter;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import top.verytouch.vkit.rbac.RbacProperties;
import top.verytouch.vkit.rbac.oauth2.AnotherClientDetailsService;
import top.verytouch.vkit.rbac.oauth2.CaptchaTokenGranter;
import top.verytouch.vkit.rbac.oauth2.InMemoryAuthorizationCodeService;
import top.verytouch.vkit.rbac.oauth2.JwtUserDetailsTokenEnhancer;
import top.verytouch.vkit.rbac.oauth2.OauthException;
import top.verytouch.vkit.rbac.oauth2.OauthExceptionSerializer;
import top.verytouch.vkit.rbac.oauth2.ParameterPasswordEncoder;

@Configuration
@EnableAuthorizationServer
public class AuthorizationSererConfig
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AnotherClientDetailsService anotherClientDetailsService;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ParameterPasswordEncoder parameterPasswordEncoder;
    @Autowired
    private AuthorizationCodeServices authorizationCodeServices;
    @Autowired
    private RbacProperties rbacProperties;
    @Autowired
    private JwtUserDetailsTokenEnhancer jwtUserDetailsTokenEnhancer;

    public void configure(AuthorizationServerSecurityConfigurer serverSecurityConfigurer) {
        serverSecurityConfigurer.allowFormAuthenticationForClients().checkTokenAccess("permitAll()").tokenKeyAccess("permitAll()").accessDeniedHandler(OauthExceptionSerializer::exceptionHandler).authenticationEntryPoint(OauthExceptionSerializer::exceptionHandler);
    }

    public void configure(ClientDetailsServiceConfigurer clientDetailsServiceConfigurer) throws Exception {
        clientDetailsServiceConfigurer.withClientDetails((ClientDetailsService)this.anotherClientDetailsService);
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpointsConfigurer) {
        endpointsConfigurer.userDetailsService(this.userDetailsService).authenticationManager(this.authenticationManager).tokenGranter(this.tokenGranter(endpointsConfigurer)).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter()).tokenStore(this.tokenStore()).reuseRefreshTokens(false).authorizationCodeServices((AuthorizationCodeServices)new InMemoryAuthorizationCodeService(Duration.ofMinutes(3L))).tokenEnhancer((TokenEnhancer)this.tokenEnhancerChain()).authorizationCodeServices(this.authorizationCodeServices).exceptionTranslator(e -> new ResponseEntity((Object)new OauthException(e.getMessage()), HttpStatus.OK));
    }

    @Bean
    public TokenStore tokenStore() {
        return new JwtTokenStore(this.jwtAccessTokenConverter());
    }

    @Bean
    public JwtAccessTokenConverter jwtAccessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey(this.rbacProperties.getJwtSingKey());
        return converter;
    }

    @Bean
    public TokenEnhancer tokenEnhancer() {
        return (accessToken, authentication) -> {
            if (this.jwtUserDetailsTokenEnhancer == null || authentication.getUserAuthentication() == null) {
                return accessToken;
            }
            UserDetails details = null;
            if (authentication.getDetails() instanceof UserDetails) {
                details = (UserDetails)authentication.getDetails();
            } else {
                Authentication userAuthentication = authentication.getUserAuthentication();
                if (userAuthentication instanceof UserDetails) {
                    details = (UserDetails)authentication.getDetails();
                } else {
                    Object principal = userAuthentication.getPrincipal();
                    if (principal instanceof UserDetails) {
                        details = (UserDetails)principal;
                    }
                }
            }
            if (details != null) {
                Map<String, Object> additionalInfo = this.jwtUserDetailsTokenEnhancer.enhance(details);
                ((DefaultOAuth2AccessToken)accessToken).setAdditionalInformation(additionalInfo);
            }
            return accessToken;
        };
    }

    private TokenEnhancerChain tokenEnhancerChain() {
        TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
        tokenEnhancerChain.setTokenEnhancers(Arrays.asList(this.tokenEnhancer(), this.jwtAccessTokenConverter()));
        return tokenEnhancerChain;
    }

    private TokenGranter tokenGranter(AuthorizationServerEndpointsConfigurer endpoints) {
        ArrayList<TokenGranter> granters = new ArrayList<TokenGranter>(Collections.singletonList(endpoints.getTokenGranter()));
        granters.add((TokenGranter)new CaptchaTokenGranter(endpoints.getTokenServices(), endpoints.getClientDetailsService(), endpoints.getOAuth2RequestFactory(), this.userDetailsService, this.passwordEncoder, this.parameterPasswordEncoder, this.rbacProperties));
        return new CompositeTokenGranter(granters);
    }
}

