/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.config;

import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import top.verytouch.vkit.common.util.StringUtils;
import top.verytouch.vkit.rbac.RbacProperties;
import top.verytouch.vkit.rbac.oauth2.OauthExceptionSerializer;

@Configuration
@EnableResourceServer
public class ResourceServerConfig
extends ResourceServerConfigurerAdapter {
    @Autowired
    private RbacProperties rbacProperties;

    public void configure(ResourceServerSecurityConfigurer resources) {
        resources.authenticationEntryPoint(OauthExceptionSerializer::exceptionHandler).accessDeniedHandler(OauthExceptionSerializer::exceptionHandler);
        if (!StringUtils.isBlank((CharSequence)this.rbacProperties.getResourceId())) {
            resources.resourceId(this.rbacProperties.getResourceId());
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/**"})).and().exceptionHandling().authenticationEntryPoint(OauthExceptionSerializer::exceptionHandler).accessDeniedHandler(OauthExceptionSerializer::exceptionHandler).and()).cors().and()).csrf().disable();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = http.authorizeRequests();
        if (this.rbacProperties.getOpenPath() != null && this.rbacProperties.getOpenPath().length > 0) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(this.rbacProperties.getOpenPath())).permitAll();
        }
        if (this.rbacProperties.getPathAnyAuthorityMapping() != null) {
            Set<Map.Entry<String, String[]>> entries = this.rbacProperties.getPathAnyAuthorityMapping().entrySet();
            entries.forEach(entry -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{(String)entry.getKey()})).hasAnyAuthority((String[])entry.getValue()));
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }
}

