/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.oauth2;

import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import top.verytouch.vkit.captcha.CaptchaContext;
import top.verytouch.vkit.rbac.RbacProperties;
import top.verytouch.vkit.rbac.oauth2.OauthException;
import top.verytouch.vkit.rbac.oauth2.ParameterPasswordEncoder;

public class CaptchaTokenGranter
extends AbstractTokenGranter {
    private static final String GRANT_TYPE = "captcha";
    private final UserDetailsService userDetailsService;
    private final PasswordEncoder passwordEncoder;
    private final ParameterPasswordEncoder parameterPasswordEncoder;
    private final RbacProperties rbacProperties;

    public CaptchaTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory, UserDetailsService userDetailService, PasswordEncoder passwordEncoder, ParameterPasswordEncoder parameterPasswordEncoder, RbacProperties rbacProperties) {
        super(tokenServices, clientDetailsService, requestFactory, GRANT_TYPE);
        this.userDetailsService = userDetailService;
        this.passwordEncoder = passwordEncoder;
        this.parameterPasswordEncoder = parameterPasswordEncoder;
        this.rbacProperties = rbacProperties;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        Map parameters = tokenRequest.getRequestParameters();
        this.verifyCode(parameters);
        UserDetails userDetails = this.verifyUserNameAndPassword(parameters);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), (Object)userDetails, userDetails.getAuthorities());
        OAuth2Authentication authentication = new OAuth2Authentication(tokenRequest.createOAuth2Request(client), (Authentication)auth);
        authentication.setDetails((Object)userDetails);
        return authentication;
    }

    private UserDetails verifyUserNameAndPassword(Map<String, String> parameters) {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(parameters.get(this.rbacProperties.getUsernameParameter()));
        String password = this.parameterPasswordEncoder.decode(parameters.get(this.rbacProperties.getPasswordParameter()));
        if (!this.passwordEncoder.matches((CharSequence)password, userDetails.getPassword())) {
            throw new OauthException("\u5bc6\u7801\u9519\u8bef");
        }
        return userDetails;
    }

    private void verifyCode(Map<String, String> parameters) {
        if (this.rbacProperties.isCaptchaEnabled()) {
            CaptchaContext.verify(parameters);
        }
    }
}

