/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import top.verytouch.vkit.common.util.HttpUtils;
import top.verytouch.vkit.common.util.JsonUtils;

public class IPUtils {
    public static String getClientIpByReq(HttpServletRequest request) {
        String clientIp = request.getHeader("X-Forward-For");
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (clientIp == null || clientIp.length() == 0 || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        String sIP = null;
        if (clientIp != null && !clientIp.contains("unknown") && clientIp.indexOf(",") > 0) {
            String[] ipArr;
            for (String ip : ipArr = clientIp.split(",")) {
                if (IPUtils.isInnerIP(ip.trim())) continue;
                sIP = ip.trim();
                break;
            }
            if (null == sIP) {
                sIP = ipArr[0].trim();
            }
            clientIp = sIP;
        }
        if (clientIp != null && clientIp.contains("unknown")) {
            clientIp = clientIp.replaceAll("unknown,", "");
            clientIp = clientIp.trim();
        }
        if ("".equals(clientIp) || null == clientIp) {
            clientIp = "127.0.0.1";
        }
        return clientIp;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = IPUtils.getIpNum(ipAddress);
        long aBegin = IPUtils.getIpNum("10.0.0.0");
        long aEnd = IPUtils.getIpNum("10.255.255.255");
        long bBegin = IPUtils.getIpNum("172.16.0.0");
        long bEnd = IPUtils.getIpNum("172.31.255.255");
        long cBegin = IPUtils.getIpNum("192.168.0.0");
        long cEnd = IPUtils.getIpNum("192.168.255.255");
        boolean isInnerIp = IPUtils.isInner(ipNum, aBegin, aEnd) || IPUtils.isInner(ipNum, bBegin, bEnd) || IPUtils.isInner(ipNum, cBegin, cEnd) || ipAddress.equals("127.0.0.1");
        return isInnerIp;
    }

    public static String getAddress(String ip) {
        try {
            String res = new HttpUtils("https://ip.taobao.com/outGetIpInfo").addParam("ip", ip).addParam("accessKey", "alibaba-inc").post();
            Map map = (Map)JsonUtils.fromJson((String)res, HashMap.class);
            if (!Objects.equals(0, map.get("code"))) {
                return "";
            }
            Map data = (Map)map.get("data");
            return data.get("country") + "/" + data.get("region") + "/" + data.get("city");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static long getIpNum(String ipAddress) {
        String[] ip = ipAddress.split("\\.");
        long a = Integer.parseInt(ip[0]);
        long b = Integer.parseInt(ip[1]);
        long c = Integer.parseInt(ip[2]);
        long d = Integer.parseInt(ip[3]);
        return a * 256L * 256L * 256L + b * 256L * 256L + c * 256L + d;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

