/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import top.verytouch.vkit.common.util.JsonUtils;

public class Oauth2Utils {
    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static String getUsername() {
        return Oauth2Utils.getAuthentication().getName();
    }

    public static Set<String> getAuthorities() {
        return Oauth2Utils.getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public static String getAccessToken() {
        return ((OAuth2AuthenticationDetails)Oauth2Utils.getAuthentication().getDetails()).getTokenValue();
    }

    public static Map<String, Object> getJwtClaims() {
        String claims = JwtHelper.decode((String)Oauth2Utils.getAccessToken()).getClaims();
        return (Map)JsonUtils.fromJson((String)claims, HashMap.class);
    }

    public static long getJwtExpireAt() {
        return Long.parseLong(Objects.toString(Oauth2Utils.getJwtClaims().get("exp"))) * 1000L;
    }
}

