/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.web;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import top.verytouch.vkit.common.base.ApiCode;
import top.verytouch.vkit.common.base.Response;
import top.verytouch.vkit.common.util.JsonUtils;

public class ResponseErrorController
extends BasicErrorController {
    public ResponseErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        super(errorAttributes, errorProperties);
    }

    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        ApiCode apiCode;
        Map info = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        switch (status) {
            case UNAUTHORIZED: {
                apiCode = ApiCode.SYS_UNAUTHENTICATED;
                break;
            }
            case FORBIDDEN: {
                apiCode = ApiCode.SYS_FORBIDDEN;
                break;
            }
            case NOT_FOUND: {
                apiCode = ApiCode.SYS_NO_HANDLER;
                break;
            }
            default: {
                apiCode = ApiCode.ERROR;
            }
        }
        Response body = Response.of((ApiCode)apiCode).setExtra(info);
        return new ResponseEntity((Object)JsonUtils.mapFromJson((String)JsonUtils.toJson((Object)body)), status);
    }
}

