/*
 * Decompiled with CFR 0.152.
 */
package top.verytouch.vkit.rbac.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;
import top.verytouch.vkit.common.base.ApiCode;
import top.verytouch.vkit.common.base.Response;
import top.verytouch.vkit.common.exception.AssertException;
import top.verytouch.vkit.common.exception.BusinessException;

@ControllerAdvice
@ResponseBody
public class RestControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(RestControllerAdvice.class);

    @ExceptionHandler(value={AssertException.class})
    public Response<String> assertException(Exception e) {
        return Response.error((int)ApiCode.PARAM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    public Response<String> businessException(Exception e) {
        return Response.error((int)ApiCode.PARAM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Response<String> nullPointerException(Exception e) {
        return this.logError(ApiCode.PARAM_ABSENT, e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Response<String> authenticationException() {
        return this.error(ApiCode.SYS_UNAUTHENTICATED);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Response<String> accessDeniedException() {
        return this.error(ApiCode.SYS_FORBIDDEN);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Response<String> noHandlerFoundException() {
        return this.error(ApiCode.SYS_NO_HANDLER);
    }

    @ExceptionHandler(value={Exception.class})
    public Response<String> exception(Exception e) {
        return this.logError(ApiCode.ERROR, e);
    }

    private Response<String> logError(ApiCode code, Exception e) {
        log.error(code.getDesc(), (Throwable)e);
        return Response.error((int)code.getCode(), (String)code.getDesc()).setTraceId(MDC.get((String)"traceId"));
    }

    private Response<String> error(ApiCode code) {
        return Response.error((int)code.getCode(), (String)code.getDesc()).setTraceId(MDC.get((String)"traceId"));
    }
}

