/*
 * Decompiled with CFR 0.152.
 */
package me.wavelength.betterreflection;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import me.wavelength.betterreflection.BetterReflectionClass;

public class BetterReflection {
    private final List<BetterReflectionClass> betterReflectionClasses = Collections.synchronizedList(new ArrayList());
    public static final BetterReflectionClass FIELD = new BetterReflectionClass(Field.class);
    private static final Map<Class<?>, BetterReflectionClass> PRIMITIVES = new HashMap();
    public static final Pattern INTEGER_PATTERN;
    public static final BetterReflectionClass JAVA_CLASS;

    public List<BetterReflectionClass> getBetterReflectionClasses() {
        return new ArrayList<BetterReflectionClass>(this.betterReflectionClasses);
    }

    public BetterReflectionClass getBetterReflectionClass(String name) {
        for (BetterReflectionClass betterReflectionClass : this.getBetterReflectionClasses()) {
            if (betterReflectionClass.getClasz().getCanonicalName() == null || !betterReflectionClass.getClasz().getCanonicalName().equals(name)) continue;
            return betterReflectionClass;
        }
        BetterReflectionClass betterReflectionClass = BetterReflectionClass.forName(name);
        if (betterReflectionClass == null) {
            return null;
        }
        this.betterReflectionClasses.add(betterReflectionClass);
        return betterReflectionClass;
    }

    public BetterReflectionClass getBetterReflectionClass(Class<?> clasz) {
        for (BetterReflectionClass betterReflectionClass : this.getBetterReflectionClasses()) {
            if (!betterReflectionClass.getClasz().equals(clasz)) continue;
            return betterReflectionClass;
        }
        BetterReflectionClass betterReflectionClass = new BetterReflectionClass(clasz);
        this.betterReflectionClasses.add(betterReflectionClass);
        return betterReflectionClass;
    }

    public static Map<Class<?>, BetterReflectionClass> getPrimitives() {
        return PRIMITIVES;
    }

    public static Object getFieldValue(BetterReflectionClass betterReflectionClass, Object instance, String fieldName) throws IllegalAccessException {
        return betterReflectionClass.getDeclaredField(fieldName).get(instance);
    }

    public static FutureTask<String> getLatestVersion() {
        return new FutureTask<String>(() -> {
            URL url = new URL("https://api.github.com/repos/OxideWaveLength/Java-BetterReflection/releases/latest");
            URLConnection connection = url.openConnection();
            InputStream in = connection.getInputStream();
            String encoding = connection.getContentType();
            encoding = encoding == null ? "UTF-8" : encoding.substring(encoding.indexOf("charset=") + 8);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int len = 0;
            while ((len = in.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            String body = baos.toString(encoding);
            for (String line : body.split("\",")) {
                if (!(line = line.replace("\"", "")).startsWith("tag_name")) continue;
                return line.substring(line.indexOf(58) + 1);
            }
            return null;
        });
    }

    public static FutureTask<Boolean> isUpToDate() {
        return new FutureTask<Boolean>(() -> {
            int[] version = BetterReflection.versionToInts(BetterReflection.getVersion());
            FutureTask<String> latestVersionFuture = BetterReflection.getLatestVersion();
            latestVersionFuture.run();
            int[] latestVersion = BetterReflection.versionToInts(latestVersionFuture.get());
            int minLength = Math.min(version.length, latestVersion.length);
            for (int i = 0; i < Math.max(version.length, latestVersion.length); ++i) {
                if (minLength <= i || version[i] <= latestVersion[i]) continue;
                return true;
            }
            return false;
        });
    }

    public static String getVersion() {
        return "0.7.1";
    }

    public static int[] versionToInts(String version) {
        if (version == null || version.trim().isEmpty()) {
            return new int[0];
        }
        int count = 1;
        for (int i = 0; i < version.length(); ++i) {
            if (version.charAt(i) != '.') continue;
            ++count;
        }
        int[] numbers = new int[count];
        for (int i = 0; i < numbers.length; ++i) {
            boolean hasNext = version != null && version.contains(".");
            String number = hasNext ? version.substring(0, version.indexOf(46)) : version;
            String string = version = hasNext ? version.substring(number.length() + 1) : null;
            if (!INTEGER_PATTERN.matcher(number).matches()) continue;
            numbers[i] = Integer.parseInt(number);
        }
        return numbers;
    }

    static {
        PRIMITIVES.put(Short.class, new BetterReflectionClass(Short.class));
        PRIMITIVES.put(Byte.class, new BetterReflectionClass(Byte.class));
        PRIMITIVES.put(Double.class, new BetterReflectionClass(Double.class));
        PRIMITIVES.put(Integer.class, new BetterReflectionClass(Integer.class));
        PRIMITIVES.put(Float.class, new BetterReflectionClass(Float.class));
        PRIMITIVES.put(Boolean.class, new BetterReflectionClass(Boolean.class));
        PRIMITIVES.put(Long.class, new BetterReflectionClass(Long.class));
        PRIMITIVES.put(Void.class, new BetterReflectionClass(Void.class));
        PRIMITIVES.put(Short.TYPE, new BetterReflectionClass(Short.TYPE));
        PRIMITIVES.put(Byte.TYPE, new BetterReflectionClass(Byte.TYPE));
        PRIMITIVES.put(Double.TYPE, new BetterReflectionClass(Double.TYPE));
        PRIMITIVES.put(Integer.TYPE, new BetterReflectionClass(Integer.TYPE));
        PRIMITIVES.put(Float.TYPE, new BetterReflectionClass(Float.TYPE));
        PRIMITIVES.put(Boolean.TYPE, new BetterReflectionClass(Boolean.TYPE));
        PRIMITIVES.put(Long.TYPE, new BetterReflectionClass(Long.TYPE));
        PRIMITIVES.put(Void.TYPE, new BetterReflectionClass(Void.TYPE));
        INTEGER_PATTERN = Pattern.compile("-?\\d+");
        JAVA_CLASS = new BetterReflectionClass(Class.class);
    }
}

