/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import top.wavelength.betterreflection.BetterReflection;
import top.wavelength.betterreflection.BetterReflectionUtils;
import top.wavelength.betterreflection.EnumBetterReflectionClass;
import top.wavelength.betterreflection.ReflectionParameter;

public class BetterReflectionClass<T> {
    protected final String name;
    protected final String simpleName;
    protected final String canonicalName;
    protected final String typeName;
    protected final String packageName;
    protected final Class<T> clasz;
    protected final Field[] declaredFields;
    protected final Field[] fields;
    protected final Constructor<?>[] declaredConstructors;
    protected final Constructor<?>[] constructors;
    protected final Method[] declaredMethods;
    protected final Method[] methods;
    protected final ProtectionDomain protectionDomain;
    protected final Class<?> superClass;
    protected BetterReflectionClass<?> betterReflectionSuperClass;
    protected final boolean isEnum;
    protected Boolean runningFromJar;
    protected JarFile jar;
    protected File jarFile;

    public BetterReflectionClass(String className) throws ClassNotFoundException {
        this(Class.forName(className));
    }

    public BetterReflectionClass(BetterReflectionClass<T> clasz) {
        this(clasz.getClasz());
    }

    public BetterReflectionClass(Class<T> clasz) {
        this.clasz = clasz;
        this.name = clasz.getName();
        this.simpleName = clasz.getSimpleName();
        this.canonicalName = clasz.getCanonicalName();
        this.typeName = clasz.getTypeName();
        this.packageName = this.name.contains(".") ? this.name.substring(0, this.name.lastIndexOf(".")) : "";
        this.declaredFields = clasz.getDeclaredFields();
        this.fields = clasz.getFields();
        this.declaredConstructors = clasz.getDeclaredConstructors();
        this.constructors = clasz.getConstructors();
        this.declaredMethods = clasz.getDeclaredMethods();
        this.methods = clasz.getMethods();
        this.superClass = clasz.getSuperclass();
        this.protectionDomain = clasz.getProtectionDomain();
        this.isEnum = clasz.isEnum();
    }

    public static BetterReflectionClass<?> forName(String name) {
        try {
            BetterReflectionClass betterReflectionClass = new BetterReflectionClass(name);
            if (betterReflectionClass.isEnum()) {
                return new EnumBetterReflectionClass(betterReflectionClass);
            }
            return betterReflectionClass;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BetterReflectionClass<?> forNameAsArray(String name) {
        BetterReflectionClass<?> clasz = BetterReflectionClass.forName(name);
        if (clasz == null) {
            return null;
        }
        return clasz.getBetterReflectionArrayClass();
    }

    public Class<T> getClasz() {
        return this.clasz;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Field getDeclaredField(String name) {
        return BetterReflectionUtils.getField(name, this.declaredFields);
    }

    public Field[] getDeclaredFields() {
        return this.declaredFields;
    }

    public Field getField(String name) {
        return BetterReflectionUtils.getField(name, this.fields);
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Constructor<?> getDeclaredConstructor(Object ... parameterTypes) {
        return this.getConstructor(BetterReflectionUtils.getTypes(parameterTypes));
    }

    public Constructor<?> getDeclaredConstructor(Class<?> ... parameterTypes) {
        return BetterReflectionUtils.getConstructor(parameterTypes, this.declaredConstructors);
    }

    public Constructor<?>[] getDeclaredConstructors() {
        return this.declaredConstructors;
    }

    public Constructor<?> getConstructor(Object ... parameterTypes) {
        return this.getConstructor(BetterReflectionUtils.getTypes(parameterTypes));
    }

    public Constructor<?> getConstructor(Class<?> ... parameterTypes) {
        return BetterReflectionUtils.getConstructor(parameterTypes, this.constructors);
    }

    public Constructor<?>[] getConstructors() {
        return this.constructors;
    }

    public Method getDeclaredMethod(String name, Object ... parameterTypes) {
        return this.getMethod(name, BetterReflectionUtils.getTypes(parameterTypes));
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) {
        return BetterReflectionUtils.getMethod(name, parameterTypes, this.declaredMethods);
    }

    public Method[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public Method getMethod(String name, Object ... parameterTypes) {
        return this.getMethod(name, BetterReflectionUtils.getTypes(parameterTypes));
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) {
        return BetterReflectionUtils.getMethod(name, parameterTypes, this.methods);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        return this.clasz.newInstance();
    }

    public Object cast(Object object) {
        return this.clasz.cast(object);
    }

    public void invokeMethods(Map<String, Object[]> methods, Object instance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (String methodName : methods.keySet()) {
            Object[] parameters = methods.get(methodName);
            HashMap primitives = new HashMap();
            for (int i = 0; i < parameters.length; ++i) {
                ReflectionParameter reflectionParameter;
                Object parameter = parameters[i];
                if (!(parameter instanceof ReflectionParameter) || !(reflectionParameter = (ReflectionParameter)parameter).getType().isPrimitive()) continue;
                primitives.put(i, reflectionParameter.getType());
                parameters[i] = BetterReflection.getPrimitives().get(reflectionParameter.getValue().getClass()).getMethod(String.format("%sValue", reflectionParameter.getType().getName()), new Class[0]).invoke(reflectionParameter.getValue(), new Object[0]);
            }
            Method method = this.getMethod(methodName, BetterReflectionUtils.getTypes(primitives, parameters));
            method.invoke(instance, parameters);
        }
    }

    public boolean isInstance(Object object) {
        return this.clasz.isInstance(object);
    }

    public <U> Class<? extends U> asSubclass(Class<U> clasz) {
        return this.clasz.asSubclass(clasz);
    }

    public Class<T[]> getArrayClass() {
        return Array.newInstance(this.clasz, 0).getClass();
    }

    public BetterReflectionClass<T[]> getBetterReflectionArrayClass() {
        return new BetterReflectionClass<T[]>(this.getArrayClass());
    }

    public Class<?> getArrayClassIf(boolean condition) {
        return condition ? this.getArrayClass() : this.clasz;
    }

    public Object getArray(Object ... content) {
        Object array = Array.newInstance(this.clasz, content.length);
        for (int i = 0; i < content.length; ++i) {
            Array.set(array, i, content[i]);
        }
        return array;
    }

    public Object getDeclaredFieldValue(Object instance, String fieldName) throws IllegalAccessException {
        return this.getDeclaredField(fieldName).get(instance);
    }

    public Object invokeMethod(Object instance, String methodName, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        return this.getMethod(methodName, BetterReflectionUtils.getTypes(parameters)).invoke(instance, parameters);
    }

    public Object invokeDeclaredMethod(Object instance, String methodName, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getDeclaredMethod(methodName, BetterReflectionUtils.getTypes(parameters));
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        Object result = method.invoke(instance, parameters);
        if (!accessible) {
            method.setAccessible(false);
        }
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Class<?> getSuperclass() {
        return this.superClass;
    }

    public BetterReflectionClass<?> getBetterReflectionSuperClass() {
        if (this.betterReflectionSuperClass == null) {
            this.betterReflectionSuperClass = new BetterReflectionClass(this.superClass);
        }
        return this.betterReflectionSuperClass;
    }

    public boolean isRunningFromJar() {
        if (this.runningFromJar == null) {
            this.runningFromJar = BetterReflectionUtils.isRunningFromJar(this);
        }
        return this.runningFromJar;
    }

    public JarFile getJar() {
        if (this.isRunningFromJar() && this.jar == null) {
            this.jar = BetterReflectionUtils.getCurrentJar(this);
        }
        return this.jar;
    }

    public File getJarFile() {
        if (this.isRunningFromJar() && this.jarFile == null) {
            this.jarFile = BetterReflectionUtils.getCurrentJarFile(this);
        }
        return this.jarFile;
    }

    public boolean isAssignableFrom(Class<?> clasz) {
        return this.clasz.isAssignableFrom(clasz);
    }

    public boolean isAssignableFrom(BetterReflectionClass clasz) {
        return this.isAssignableFrom(clasz.getClasz());
    }

    public void dumpMethodHeaders() {
        this.dumpMethodHeaders(true);
    }

    public void dumpMethodHeaders(boolean includeModifiers) {
        this.dumpMethodHeaders(includeModifiers, true);
    }

    public void dumpMethodHeaders(boolean includeModifiers, boolean includeReturnType) {
        this.dumpMethodHeaders(includeModifiers, includeReturnType, true);
    }

    public void dumpMethodHeaders(boolean includeModifiers, boolean includeReturnType, boolean includeParameterNames) {
        for (Method method : this.getDeclaredMethods()) {
            BetterReflectionUtils.dumpMethodHeader(method, includeModifiers, includeReturnType, includeParameterNames);
        }
    }

    public T allocateUnsafeInstance() throws IllegalAccessException, InstantiationException {
        return (T)BetterReflectionUtils.allocateUnsafeInstance(this.clasz);
    }

    public boolean isEnum() {
        return this.clasz.isEnum();
    }

    public boolean isEnumWrapped() {
        return this instanceof EnumBetterReflectionClass;
    }
}

