/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.lookup;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import top.wavelength.betterreflection.BetterReflectionClass;
import top.wavelength.betterreflection.BetterReflectionUtils;
import top.wavelength.betterreflection.lookup.ClassFinder;

public class IdeClassFinder<T>
extends ClassFinder<T> {
    public IdeClassFinder(String packageName) {
        super(packageName);
    }

    @Override
    public List<BetterReflectionClass<T>> findClasses() throws IOException, URISyntaxException {
        return this.scanDirectory(BetterReflectionUtils.getDirectoriesFromPackageName(this.basePackage), this.basePackage);
    }

    public List<BetterReflectionClass<T>> scanDirectory(List<File> directories, String packageName) {
        ArrayList<BetterReflectionClass<T>> classes = new ArrayList<BetterReflectionClass<T>>();
        for (File directory : directories) {
            File[] files = directory.listFiles();
            assert (files != null);
            for (File file : files) {
                if (file.isDirectory() && this.isRecursive()) {
                    classes.addAll(this.scanDirectory(Collections.singletonList(file), packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                BetterReflectionClass<?> clasz = BetterReflectionClass.forName(packageName + '.' + file.getName().substring(0, file.getName().lastIndexOf(46)));
                if (this.getType() != null && !this.getType().isAssignableFrom(Objects.requireNonNull(clasz))) continue;
                classes.add(clasz);
            }
        }
        return classes;
    }
}

