/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import sun.misc.Unsafe;
import top.wavelength.betterreflection.BetterReflection;
import top.wavelength.betterreflection.BetterReflectionClass;
import top.wavelength.betterreflection.ReflectionParameter;
import top.wavelength.betterreflection.exceptions.CannotReadJarException;
import top.wavelength.betterreflection.lookup.ClassFinderFactory;

public class BetterReflectionUtils {
    public static final BetterReflectionClass<BetterReflectionUtils> CLASS = new BetterReflectionClass<BetterReflectionUtils>(BetterReflectionUtils.class);
    public static final File LAUNCH_JAR_FILE = BetterReflectionUtils.getCurrentJarFile(CLASS);

    public static File getCurrentJarFile(BetterReflectionClass<?> clasz) {
        if (!BetterReflectionUtils.isRunningFromJar()) {
            return null;
        }
        try {
            return new File(clasz.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getCurrentJarFile() {
        return BetterReflectionUtils.getCurrentJarFile(CLASS);
    }

    public static JarFile getCurrentJar(BetterReflectionClass<?> clasz) {
        File file = BetterReflectionUtils.getCurrentJarFile(clasz);
        if (file == null) {
            return null;
        }
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JarFile getCurrentJar() {
        return BetterReflectionUtils.getCurrentJar(CLASS);
    }

    public static boolean isRunningFromJar(BetterReflectionClass<?> clasz) {
        if (BetterReflectionUtils.isRunningOnAndroid()) {
            return false;
        }
        try {
            return clasz.getProtectionDomain().getCodeSource().getLocation().toURI().toString().endsWith(".jar");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isRunningFromJar() {
        return BetterReflectionUtils.isRunningFromJar(CLASS);
    }

    public static boolean isRunningOnAndroid() {
        try {
            new BetterReflectionClass("android.R");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Field getField(String name, Field[] fields) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?>[] parameterTypes, Constructor<?>[] constructors) {
        for (Constructor<?> constructor : constructors) {
            if (!BetterReflectionUtils.doParametersMatch(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static Method getMethod(String name, Class<?>[] parameterTypes, Method[] methods) {
        for (Method method : methods) {
            if (!method.getName().equals(name) || !BetterReflectionUtils.doParametersMatch(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    public static boolean doParametersMatch(Class<?>[] parameters1, Class<?>[] parameters2) {
        if (parameters1.length != parameters2.length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            if (parameters1[i].equals(parameters2[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static Class<?>[] getClasses(Object ... parameterTypes) {
        return BetterReflectionUtils.getClasses(null, parameterTypes);
    }

    @Deprecated
    public static Class<?>[] getClasses(Map<Integer, Class<?>> primitives, Object ... parameterTypes) {
        return BetterReflectionUtils.getTypes(primitives, parameterTypes);
    }

    public static Class<?>[] getTypes(Object ... parameterTypes) {
        return BetterReflectionUtils.getTypes(null, parameterTypes);
    }

    public static Class<?>[] getTypes(Map<Integer, Class<?>> primitives, Object ... parameterTypes) {
        Class[] parameterTypesRefined = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            if (parameterType == null) continue;
            if (parameterType instanceof ReflectionParameter) {
                parameterType = ((ReflectionParameter)parameterType).getValue();
            }
            if (parameterType == null) continue;
            parameterTypesRefined[i] = primitives != null && primitives.containsKey(i) ? primitives.get(i) : (parameterType instanceof BetterReflectionClass ? ((BetterReflectionClass)parameterType).getClasz() : (parameterType instanceof Class ? (Class<?>)parameterType : parameterType.getClass()));
        }
        return parameterTypesRefined;
    }

    public static List<File> getDirectoriesFromPackageName(String packageName) throws IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> directories = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            directories.add(new File(resource.toURI()));
        }
        return directories;
    }

    @Deprecated
    public static List<BetterReflectionClass<Object>> getClassesInPackage(String packageName) throws IOException, URISyntaxException, CannotReadJarException {
        return ClassFinderFactory.create(packageName, CLASS).findClasses();
    }

    public static List<BetterReflectionClass<?>> getClassesFromNameBeginning(String packageName, String beginning) throws IOException, URISyntaxException, CannotReadJarException {
        ArrayList classes = new ArrayList();
        for (BetterReflectionClass<Object> clasz : BetterReflectionUtils.getClassesInPackage(packageName)) {
            if (!clasz.getSimpleName().startsWith(beginning)) continue;
            classes.add(clasz);
        }
        return classes;
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static void setFinal(Field field, boolean setFinal) throws Exception {
        int version = BetterReflectionUtils.getJavaVersion();
        Exception exception = AccessController.doPrivileged(() -> {
            Field modifiers = null;
            try {
                if (version >= 11) {
                    Field[] fields;
                    Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                    getDeclaredFields0.setAccessible(true);
                    for (Field each : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                        if (!"modifiers".equals(each.getName())) continue;
                        modifiers = each;
                        break;
                    }
                    assert (modifiers != null);
                } else {
                    field.setAccessible(true);
                    modifiers = Field.class.getDeclaredField("modifiers");
                }
                modifiers.setAccessible(true);
                if (!setFinal && Modifier.isFinal(field.getModifiers())) {
                    modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                if (setFinal && !Modifier.isFinal(field.getModifiers())) {
                    modifiers.setInt(field, field.getModifiers() & 0x10);
                }
            }
            catch (Exception e) {
                return e;
            }
            return null;
        });
        if (exception != null) {
            if (version >= 11) {
                System.err.println("You seem to be using Java 11 or higher. Please, make sure that you have either of the following launch parameters set specified:");
                System.err.println("\tJava 16 and below: --illegal-access=permit");
                System.err.println("\tJava 17 and above: --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.lang.reflect=ALL-UNNAMED");
            }
            throw exception;
        }
    }

    @Deprecated
    public static String generateMethodHeader(Method method, boolean includeModifiers, boolean includeReturnType, boolean includeParameterNames) {
        StringBuilder parameters = new StringBuilder();
        for (Parameter parameter : method.getParameters()) {
            if (parameters.length() != 0) {
                parameters.append(", ");
            }
            parameters.append(parameter.getType().getName());
            if (!includeParameterNames) continue;
            parameters.append(" ").append(parameter.getName());
        }
        return String.format("%s%s%s(%s)", includeModifiers ? Modifier.toString(method.getModifiers()) + " " : "", includeReturnType ? method.getReturnType().getName() + " " : "", method.getName(), parameters);
    }

    @Deprecated
    public static void dumpMethodHeader(Method method, boolean includeModifiers, boolean includeReturnType, boolean includeParameterNames) {
        System.out.println(BetterReflectionUtils.generateMethodHeader(method, includeModifiers, includeReturnType, includeParameterNames));
    }

    public static Object allocateUnsafeInstance(Class<?> clasz) throws IllegalAccessException, InstantiationException {
        Field field = BetterReflection.UNSAFE_CLASS.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        Unsafe unsafe = (Unsafe)field.get(null);
        return unsafe.allocateInstance(clasz);
    }

    public static String getCallerClassName(int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > depth) {
            StackTraceElement callerElement = stackTrace[depth];
            return callerElement.getClassName();
        }
        return null;
    }

    public static String getCallerClassName() {
        return BetterReflectionUtils.getCallerClassName(3);
    }

    public static BetterReflectionClass<?> getCallerClass(int depth) {
        String className = BetterReflectionUtils.getCallerClassName(depth);
        if (className == null) {
            return null;
        }
        return BetterReflection.INSTANCE.getBetterReflectionClass(className);
    }

    public static BetterReflectionClass<?> getCallerClass() {
        return BetterReflectionUtils.getCallerClass(3);
    }
}

