/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.wavelength.betterreflection.BetterReflectionClass;
import top.wavelength.betterreflection.BetterReflectionUtils;
import top.wavelength.betterreflection.exceptions.CannotReadJarException;
import top.wavelength.betterreflection.lookup.ClassFinder;

public class JarClassFinder<T>
extends ClassFinder<T> {
    public JarClassFinder(String packageName) {
        super(packageName);
    }

    @Override
    public List<BetterReflectionClass<T>> findClasses() throws IOException {
        if (this.basePackage == null || this.basePackage.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BetterReflectionClass<T>> classes = new ArrayList<BetterReflectionClass<T>>();
        String basePackage = this.basePackage.replace('.', '/');
        if (BetterReflectionUtils.LAUNCH_JAR_FILE == null || !BetterReflectionUtils.LAUNCH_JAR_FILE.exists() || !BetterReflectionUtils.LAUNCH_JAR_FILE.canRead()) {
            throw new CannotReadJarException(BetterReflectionUtils.LAUNCH_JAR_FILE == null ? "[NO NAME]" : BetterReflectionUtils.LAUNCH_JAR_FILE.getName());
        }
        try (JarFile jar = new JarFile(BetterReflectionUtils.LAUNCH_JAR_FILE);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry entry = entries.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                String packageName = entry.getName().substring(0, name.lastIndexOf(47)).replace('/', '.');
                String className = entry.getName().substring(packageName.length() + 1, entry.getName().lastIndexOf(46));
                String fullName = packageName + '.' + className;
                BetterReflectionClass<?> clasz = BetterReflectionClass.forName(fullName);
                if (this.getType() == null || this.getType().isAssignableFrom(Objects.requireNonNull(clasz))) {
                    classes.add(clasz);
                }
                if (this.isRecursive()) {
                    if (!packageName.startsWith(basePackage)) continue;
                    classes.add(clasz);
                    continue;
                }
                if (!packageName.equals(basePackage)) continue;
                classes.add(clasz);
            }
        }
        return classes;
    }
}

