/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection;

import java.util.Optional;
import top.wavelength.betterreflection.BetterReflection;
import top.wavelength.betterreflection.BetterReflectionClass;

public class EnumBetterReflectionClass<T extends Enum<?>>
extends BetterReflectionClass<T> {
    protected T[] enumConstants;

    public EnumBetterReflectionClass(String className) throws ClassNotFoundException {
        super(className);
        this.init();
    }

    public EnumBetterReflectionClass(BetterReflectionClass<T> clasz) {
        super(clasz);
        this.init();
    }

    public EnumBetterReflectionClass(Class<T> clasz) {
        super(clasz);
        this.init();
    }

    private void init() {
        if (!this.isEnum()) {
            throw new IllegalStateException("Trying to wrap a non-enum class ('" + this.name + "')");
        }
        try {
            this.enumConstants = (Enum[])BetterReflection.JAVA_CLASS.getDeclaredMethod("getEnumConstants", new Class[0]).invoke((Object)this.clasz, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T[] getEnumConstants() {
        return this.enumConstants;
    }

    public boolean contains(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        for (T e : this.enumConstants) {
            if (!((Enum)e).name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public Optional<T> getIfPresent(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Optional.empty();
        }
        for (T e : this.enumConstants) {
            if (!((Enum)e).name().equals(value)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public T getOrNull(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        for (T e : this.enumConstants) {
            if (!((Enum)e).name().equals(value)) continue;
            return e;
        }
        return null;
    }

    public T getOrDefault(String value, T defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        for (T e : this.enumConstants) {
            if (!((Enum)e).name().equals(value)) continue;
            return e;
        }
        return defaultValue;
    }

    public String toString(String separator) {
        if (separator == null) {
            separator = "";
        }
        StringBuilder string = new StringBuilder();
        for (T e : this.enumConstants) {
            string.append(string.length() > 0 ? separator : "").append(((Enum)e).name());
        }
        return string.toString();
    }

    public String toString() {
        return this.toString(", ");
    }
}

