/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.dumper.implementation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import top.wavelength.betterreflection.dumper.Dumper;
import top.wavelength.betterreflection.dumper.TypeDisplayNameFormat;

public class MethodDumper
implements Dumper<Method> {
    private boolean includeModifiers = true;
    private TypeDisplayNameFormat parameterTypeDisplay = TypeDisplayNameFormat.FULL_NAME;
    private TypeDisplayNameFormat returnTypeDisplay = TypeDisplayNameFormat.FULL_NAME;

    public boolean isIncludeModifiers() {
        return this.includeModifiers;
    }

    public MethodDumper setIncludeModifiers(boolean includeModifiers) {
        this.includeModifiers = includeModifiers;
        return this;
    }

    public TypeDisplayNameFormat getParameterTypeDisplay() {
        return this.parameterTypeDisplay;
    }

    public MethodDumper setParameterTypeDisplay(TypeDisplayNameFormat parameterTypeDisplay) {
        this.parameterTypeDisplay = parameterTypeDisplay;
        return this;
    }

    public TypeDisplayNameFormat getReturnTypeDisplay() {
        return this.returnTypeDisplay;
    }

    public MethodDumper setReturnTypeDisplay(TypeDisplayNameFormat returnType) {
        this.returnTypeDisplay = returnType;
        return this;
    }

    @Override
    public String dump(Method method) {
        StringBuilder parameters = new StringBuilder();
        if (this.parameterTypeDisplay != TypeDisplayNameFormat.NONE) {
            for (Parameter parameter : method.getParameters()) {
                if (parameters.length() != 0) {
                    parameters.append(", ");
                }
                parameters.append(this.parameterTypeDisplay.getName(parameter));
            }
        }
        return String.format("%s%s%s(%s)", this.includeModifiers ? Modifier.toString(method.getModifiers()) + " " : "", this.returnTypeDisplay != TypeDisplayNameFormat.NONE ? this.returnTypeDisplay.getName(method) + " " : "", method.getName(), parameters);
    }
}

