/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.lookup;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import top.wavelength.betterreflection.BetterReflectionClass;
import top.wavelength.betterreflection.BetterReflectionUtils;

public abstract class ClassFinder<T>
implements Iterable<BetterReflectionClass<T>> {
    protected final String basePackage;
    private boolean recursive;
    private BetterReflectionClass<T> type;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private File jarFile = BetterReflectionUtils.LAUNCH_JAR_FILE;

    public ClassFinder(String basePackage) {
        this.basePackage = basePackage;
    }

    public ClassFinder<T> ofType(Class<T> type) {
        return this.ofType(new BetterReflectionClass<T>(type));
    }

    public ClassFinder<T> ofType(BetterReflectionClass<T> type) {
        this.type = type;
        return this;
    }

    public BetterReflectionClass<?> getType() {
        return this.type;
    }

    public ClassFinder<T> recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public ClassFinder<T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassFinder<T> jarFile(File jarFile) {
        this.jarFile = jarFile;
        return this;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public abstract List<BetterReflectionClass<T>> findClasses() throws IOException, URISyntaxException;

    @Override
    public Iterator<BetterReflectionClass<T>> iterator() {
        try {
            return this.findClasses().iterator();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

