/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.dumper.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import top.wavelength.betterreflection.dumper.Dumper;
import top.wavelength.betterreflection.dumper.TypeDisplayNameFormat;

public class ConstructorDumper
implements Dumper<Constructor<?>> {
    private boolean includeModifiers = true;
    private TypeDisplayNameFormat parameterTypeDisplay = TypeDisplayNameFormat.FULL_NAME;

    public boolean isIncludeModifiers() {
        return this.includeModifiers;
    }

    public ConstructorDumper setIncludeModifiers(boolean includeModifiers) {
        this.includeModifiers = includeModifiers;
        return this;
    }

    public TypeDisplayNameFormat getParameterTypeDisplay() {
        return this.parameterTypeDisplay;
    }

    public ConstructorDumper setParameterTypeDisplay(TypeDisplayNameFormat parameterTypeDisplay) {
        this.parameterTypeDisplay = parameterTypeDisplay;
        return this;
    }

    @Override
    public String dump(Constructor<?> constructor) {
        StringBuilder parameters = new StringBuilder();
        if (this.parameterTypeDisplay != TypeDisplayNameFormat.NONE) {
            for (Parameter parameter : constructor.getParameters()) {
                if (parameters.length() != 0) {
                    parameters.append(", ");
                }
                parameters.append(this.parameterTypeDisplay.getName(parameter));
            }
        }
        return String.format("%s%s(%s)", this.includeModifiers ? Modifier.toString(constructor.getModifiers()) + " " : "", "init", parameters);
    }
}

