/*
 * Decompiled with CFR 0.152.
 */
package top.wavelength.betterreflection.lookup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.wavelength.betterreflection.BetterReflectionClass;
import top.wavelength.betterreflection.exceptions.CannotReadJarException;
import top.wavelength.betterreflection.lookup.ClassFinder;

public class JarClassFinder<T>
extends ClassFinder<T> {
    public JarClassFinder(String packageName) {
        super(packageName);
    }

    @Override
    public List<BetterReflectionClass<T>> findClasses() throws IOException {
        ArrayList<BetterReflectionClass<T>> classes = new ArrayList<BetterReflectionClass<T>>();
        String basePackage = this.basePackage == null ? "" : this.basePackage.replace('.', '/');
        File jarFile = this.getJarFile();
        if (jarFile == null || !jarFile.exists() || !jarFile.canRead()) {
            throw new CannotReadJarException(jarFile == null ? "[NO NAME]" : jarFile.getName());
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                BetterReflectionClass clasz;
                String name;
                JarEntry entry = entries.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                String packageName = entry.getName().substring(0, name.lastIndexOf(47)).replace('/', '.');
                String className = entry.getName().substring(packageName.length() + 1, entry.getName().lastIndexOf(46));
                String fullName = packageName + '.' + className;
                if (this.isRecursive() && !packageName.startsWith(basePackage) || !this.isRecursive() && !packageName.equalsIgnoreCase(basePackage)) continue;
                try {
                    clasz = new BetterReflectionClass(Class.forName(fullName, true, this.getClassLoader()));
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    continue;
                }
                if (this.getType() != null && !this.getType().isAssignableFrom(Objects.requireNonNull(clasz))) continue;
                classes.add(clasz);
            }
        }
        return classes;
    }
}

