/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.manager.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import top.xcphoenix.jfjw.expection.PublicKeyException;
import top.xcphoenix.jfjw.manager.KeyManager;
import top.xcphoenix.jfjw.manager.impl.UrlManagerImpl;
import top.xcphoenix.jfjw.util.B64Util;
import top.xcphoenix.jfjw.util.HttpClientUtils;
import top.xcphoenix.jfjw.util.RsaUtil;

public class KeyManagerImpl
implements KeyManager {
    private static KeyManager instance;
    private static final String MODULUS = "modulus";
    private static final String EXPONENT = "exponent";

    private KeyManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager getInstance() {
        if (instance != null) return instance;
        Class<KeyManagerImpl> clazz = KeyManagerImpl.class;
        synchronized (KeyManagerImpl.class) {
            if (instance != null) return instance;
            instance = new KeyManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public RsaUtil getPublicKey(String baseUrl) {
        return this.getPublicKey(baseUrl, null, null);
    }

    @Override
    public RsaUtil getPublicKey(String url, HttpClientContext context) {
        return this.getPublicKey(url, null, context);
    }

    @Override
    public RsaUtil getPublicKey(String url, Map<String, String> headers) {
        return this.getPublicKey(url, headers, null);
    }

    @Override
    public RsaUtil getPublicKey(String baseUrl, Map<String, String> headers, HttpClientContext context) {
        String exponent;
        String modulus;
        HttpGet httpGet;
        URIBuilder uriBuilder = null;
        try {
            uriBuilder = UrlManagerImpl.getInstance().getPublicKeyLink(baseUrl);
            httpGet = new HttpGet(uriBuilder.build());
            if (headers != null && !headers.isEmpty()) {
                httpGet.setHeaders((Header[])headers.entrySet().stream().map(o -> new BasicHeader((String)o.getKey(), (String)o.getValue())).toArray(Header[]::new));
            }
        }
        catch (URISyntaxException e) {
            throw new PublicKeyException("publicKeyUrl is invalid, url: " + (uriBuilder != null ? uriBuilder.toString() : "null"), e);
        }
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            JSONObject jsonObject = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            modulus = B64Util.b64ToHex(jsonObject.getString(MODULUS));
            exponent = B64Util.b64ToHex(jsonObject.getString(EXPONENT));
        }
        catch (IOException e) {
            throw new PublicKeyException("IO error happened on get publicKeyUrl processor: url: " + uriBuilder.toString(), e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new RsaUtil(modulus, exponent);
    }

    @Override
    public String encryptPassword(RsaUtil rsaUtil, String value) {
        return B64Util.hex2b64(rsaUtil.rsaEncrypt(value));
    }
}

