/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.manager.impl;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import top.xcphoenix.jfjw.manager.UrlManager;

public class UrlManagerImpl
implements UrlManager {
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String PUBLIC_KEY_URL = "/jwglxt/xtgl/login_getPublicKey.html";
    private static final String INDEX_URL = "/jwglxt/xtgl/login_slogin.html";
    private static final String LOGIN_URL = "/jwglxt/xtgl/login_slogin.html";
    private static final String USER_INFO_API_URL = "/jwglxt/xsxxxggl/xsxxwh_cxCkDgxsxx.html";
    private static final String CLASS_TABLE_API_URL = "/jwglxt/kbcx/xskbcx_cxXsKb.html";
    private static final String CLASS_TABLE_SIMPLE_PAGE = "/jwglxt/kbcx/xskbcx_cxXskbcxIndex.html";
    private static UrlManager instance;

    private UrlManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UrlManager getInstance() {
        if (instance != null) return instance;
        Class<UrlManagerImpl> clazz = UrlManagerImpl.class;
        synchronized (UrlManagerImpl.class) {
            if (instance != null) return instance;
            instance = new UrlManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public URIBuilder getPublicKeyLink(String baseUrl) throws URISyntaxException {
        return this.afterCurrTimeDecorate(this.getUrl(baseUrl, PUBLIC_KEY_URL));
    }

    @Override
    public URIBuilder getIndexLink(String baseUrl) throws URISyntaxException {
        return this.afterCurrTimeDecorate(this.getUrl(baseUrl, "/jwglxt/xtgl/login_slogin.html"), "_t").setParameter("language", "zh_CN");
    }

    @Override
    public URIBuilder getLoginLink(String baseUrl) throws URISyntaxException {
        return this.afterCurrTimeDecorate(this.getUrl(baseUrl, "/jwglxt/xtgl/login_slogin.html"));
    }

    @Override
    public URIBuilder getUserInfoApiLink(String baseUrl) throws URISyntaxException {
        return this.afterDecorate(this.getUrl(baseUrl, USER_INFO_API_URL)).setParameter("gnmkdm", "N100801");
    }

    @Override
    public String getLoginRedirectLink() {
        return "/jwglxt/xtgl/login_slogin.html";
    }

    @Override
    public URIBuilder getClassTableApiLink(String baseUrl) throws URISyntaxException {
        return this.afterDecorate(this.getUrl(baseUrl, CLASS_TABLE_API_URL)).setParameter("gnmkdm", "N253508");
    }

    @Override
    public URIBuilder getClassTableSimplePage(String baseUrl) throws URISyntaxException {
        return this.afterDecorate(this.getUrl(baseUrl, CLASS_TABLE_SIMPLE_PAGE)).setParameter("gnmkdm", "N253508");
    }

    protected String getUrl(String baseUrl, String link) {
        return "http://" + (!baseUrl.endsWith("/") ? baseUrl : baseUrl.substring(0, baseUrl.length() - 1)) + link;
    }

    protected URIBuilder afterDecorate(String string) throws URISyntaxException {
        return new URIBuilder(string);
    }

    protected URIBuilder afterCurrTimeDecorate(String string) throws URISyntaxException {
        return this.afterCurrTimeDecorate(string, "time");
    }

    protected URIBuilder afterCurrTimeDecorate(String string, String key) throws URISyntaxException {
        URIBuilder uriBuilder = this.afterDecorate(string);
        if (key == null) {
            return uriBuilder;
        }
        uriBuilder.setParameter(key, String.valueOf(System.currentTimeMillis()));
        return uriBuilder;
    }
}

