/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.service;

import java.io.IOException;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import top.xcphoenix.jfjw.config.ServiceConfig;
import top.xcphoenix.jfjw.expection.ConfigException;
import top.xcphoenix.jfjw.expection.NotLoggedInException;
import top.xcphoenix.jfjw.manager.UrlManager;
import top.xcphoenix.jfjw.manager.impl.UrlManagerImpl;
import top.xcphoenix.jfjw.model.login.LoginStatus;
import top.xcphoenix.jfjw.util.HttpClientUtils;

public abstract class BaseService {
    protected String domain;
    protected HttpClientContext context;
    protected UrlManager urlManager = UrlManagerImpl.getInstance();
    protected CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?$");

    public BaseService() {
        this(ServiceConfig.getGlobalConfig());
    }

    public BaseService(ServiceConfig config) {
        if (config == null) {
            throw new ConfigException("cannot find global config");
        }
        this.init(config);
    }

    protected void init(ServiceConfig config) {
        if (!this.validateDomain(config.getDomain())) {
            throw new RuntimeException("domain invalid");
        }
        this.domain = config.getDomain();
        this.context = HttpClientContext.create();
        this.context.setCookieStore(config.getCookieStore());
    }

    protected String getResp(@NonNull CloseableHttpResponse response) throws IOException, NotLoggedInException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String page = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.isNeedLogin(response)) {
            throw new NotLoggedInException(this.getErrLoginStatus(page));
        }
        return page;
    }

    protected boolean isNeedLogin(@NonNull CloseableHttpResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        return response.getStatusLine().getStatusCode() == 302 && response.getFirstHeader("Location").getValue().startsWith(this.urlManager.getLoginRedirectLink());
    }

    protected LoginStatus getErrLoginStatus(String html) {
        String tipsId = "tips";
        String errorClass = "bg_danger sl_danger";
        Document document = Jsoup.parse((String)html);
        Element element = document.getElementById(tipsId);
        String msg = null;
        if (element == null) {
            Elements elements = document.getElementsByClass(errorClass);
            if (elements != null && !elements.isEmpty()) {
                msg = String.join((CharSequence)",", elements.eachText());
            }
        } else {
            msg = element.text();
        }
        return LoginStatus.error(msg);
    }

    private boolean validateDomain(@NonNull String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        return domain != null && DOMAIN_PATTERN.matcher(domain).matches();
    }
}

