/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.service.core.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import top.xcphoenix.jfjw.expection.NotLoggedInException;
import top.xcphoenix.jfjw.expection.ServiceException;
import top.xcphoenix.jfjw.model.course.Course;
import top.xcphoenix.jfjw.model.course.CourseTpMeta;
import top.xcphoenix.jfjw.service.BaseService;
import top.xcphoenix.jfjw.service.core.ClassTableService;

public class ClassTableServiceImpl
extends BaseService
implements ClassTableService {
    private static Map<Integer, Integer> periodMap = new HashMap<Integer, Integer>(2);

    @Override
    public List<Course> getCourses() throws NotLoggedInException {
        int[] data = this.getNowPeriod();
        return this.getCourses(data[0], data[1]);
    }

    @Override
    public List<Course> getCourses(int year, int num) throws NotLoggedInException {
        List<Course> list;
        block9: {
            CloseableHttpResponse response = this.sendReq(year, ClassTableServiceImpl.getStudyPeriod(num));
            try {
                if (super.isNeedLogin(response)) {
                    throw new NotLoggedInException("need login");
                }
                list = this.dealWithResp(response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("io error");
                }
            }
            response.close();
        }
        return list;
    }

    public static void setPeriodMap(Map<Integer, Integer> periodMap) {
        ClassTableServiceImpl.periodMap = periodMap;
    }

    private CloseableHttpResponse sendReq(int year, int period) {
        HttpPost httpPost;
        try {
            httpPost = new HttpPost(this.urlManager.getClassTableApiLink(this.domain).build());
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(ClassTableServiceImpl.convertYearPeriod(year, period), Consts.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new ServiceException("get classTable api url is invalid");
        }
        try {
            return this.httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
        }
        catch (IOException e) {
            throw new ServiceException("io error");
        }
    }

    private List<Course> dealWithResp(CloseableHttpResponse response) throws NotLoggedInException {
        String page;
        try {
            page = super.getResp(response);
        }
        catch (IOException ioException) {
            throw new ServiceException("io error", ioException);
        }
        HashMap<String, Course> idMapCourse = new HashMap<String, Course>();
        JSONArray courseArray = JSON.parseObject((String)page).getJSONArray("kbList");
        if (courseArray == null) {
            throw new ServiceException("classTable not found");
        }
        for (int i = 0; i < courseArray.size(); ++i) {
            JSONObject obj = courseArray.getJSONObject(i);
            String cName = obj.getString("kcmc");
            Course course = (Course)idMapCourse.get(cName);
            if (course == null) {
                course = new Course();
                course.setCourseName(cName);
                course.setTeacher(obj.getString("xm"));
                course.setScore(Double.parseDouble(obj.getString("xf")));
                course.setAccessKind(obj.getString("khfsmc"));
                course.setCompositionOfTime(obj.getString("kcxszc"));
                course.setWeekTime(Integer.parseInt(obj.getString("zhxs")));
                course.setAllTime(Integer.parseInt(obj.getString("zxs")));
                course.setCourseTpMetas(new ArrayList<CourseTpMeta>());
            }
            List<CourseTpMeta> metas = course.getCourseTpMetas();
            CourseTpMeta meta = new CourseTpMeta();
            this.dealMetaWeek(meta, obj.getString("zcd"));
            meta.setWeek(DayOfWeek.of(Integer.parseInt(obj.getString("xqj"))));
            this.dealMetaPeriod(meta, obj.getString("jcs"));
            meta.setPosition(String.join((CharSequence)" ", obj.getString("xqmc"), obj.getString("cdmc")));
            metas.add(meta);
            idMapCourse.put(cName, course);
        }
        return new ArrayList<Course>(idMapCourse.values());
    }

    private void dealMetaPeriod(CourseTpMeta meta, String str) {
        String[] items = str.split("-");
        meta.setStartPeriod(Integer.parseInt(items[0]));
        if (items.length > 1) {
            meta.setEndPeriod(Integer.parseInt(items[1]));
        } else {
            meta.setEndPeriod(meta.getStartPeriod());
        }
    }

    private void dealMetaWeek(CourseTpMeta meta, String str) {
        String regex = "(\\d+)-(\\d+)\u5468(\\((.)\\))?";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find() && matcher.groupCount() >= 2) {
            meta.setStartWeek(Integer.parseInt(matcher.group(1)));
            meta.setEndWeek(Integer.parseInt(matcher.group(2)));
            if (matcher.group(4) != null) {
                meta.setWeekKind(CourseTpMeta.WeekKind.parse(matcher.group(4)));
            }
            return;
        }
        throw new ServiceException("parse course week data error");
    }

    private static List<NameValuePair> convertYearPeriod(int year, int period) {
        String yearParamName = "xnm";
        String periodParamName = "xqm";
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>(2);
        list.add((NameValuePair)new BasicNameValuePair(yearParamName, String.valueOf(year)));
        list.add((NameValuePair)new BasicNameValuePair(periodParamName, String.valueOf(period)));
        return list;
    }

    private static int getStudyPeriod(int val) {
        if (val > 0 && val < 3 && periodMap.containsKey(val)) {
            return periodMap.get(val);
        }
        return val;
    }

    private int[] getNowPeriod() throws ServiceException, NotLoggedInException {
        HttpGet httpGet;
        String yearId = "xnm";
        String periodId = "xqm";
        int[] res = new int[2];
        try {
            httpGet = new HttpGet(this.urlManager.getClassTableSimplePage(this.domain).build());
        }
        catch (URISyntaxException e2) {
            throw new ServiceException("get classTable simple page url is invalid");
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);){
            String page = super.getResp(response);
            Document document = Jsoup.parse((String)page);
            Elements elements = document.getElementById(yearId).getElementsByTag("option");
            res[0] = Integer.parseInt(((Element)elements.stream().filter(e -> "selected".equals(e.attr("selected"))).collect(Collectors.toList()).get(0)).attr("value"));
            elements = document.getElementById(periodId).getElementsByTag("option");
            res[1] = Integer.parseInt(((Element)elements.stream().filter(e -> "selected".equals(e.attr("selected"))).collect(Collectors.toList()).get(0)).attr("value"));
        }
        catch (IOException e3) {
            throw new ServiceException("io error", e3);
        }
        return res;
    }

    static {
        periodMap.put(1, 3);
        periodMap.put(2, 12);
    }
}

