/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.service.core.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import top.xcphoenix.jfjw.expection.LoginException;
import top.xcphoenix.jfjw.expection.NotLoggedInException;
import top.xcphoenix.jfjw.expection.ServiceException;
import top.xcphoenix.jfjw.manager.KeyManager;
import top.xcphoenix.jfjw.manager.impl.KeyManagerImpl;
import top.xcphoenix.jfjw.model.login.LoginData;
import top.xcphoenix.jfjw.model.login.LoginStatus;
import top.xcphoenix.jfjw.model.user.User;
import top.xcphoenix.jfjw.service.BaseService;
import top.xcphoenix.jfjw.service.core.LoginService;

public class LoginServiceImpl
extends BaseService
implements LoginService {
    private KeyManager keyManager = KeyManagerImpl.getInstance();

    @Override
    public LoginStatus login(User user) throws LoginException {
        LoginData.CovertData covertData = this.sendIndex(user);
        return this.sendLogin(covertData);
    }

    protected LoginData.CovertData sendIndex(User user) throws LoginException {
        String password;
        LoginData loginData;
        CloseableHttpResponse response = null;
        try {
            String csrfToken;
            HttpGet httpGet = new HttpGet(this.urlManager.getIndexLink(this.domain).build());
            response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
            Document document = Jsoup.parse((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            Element element = document.getElementById("csrftoken");
            if (element == null || (csrfToken = element.attr("value")) == null || csrfToken.length() == 0) {
                throw new LoginException("csrftoken not found on index page, page content: " + document.outerHtml());
            }
            loginData = new LoginData(csrfToken, user);
            password = this.keyManager.encryptPassword(this.keyManager.getPublicKey(this.domain, this.context), user.getPassword());
        }
        catch (IOException | URISyntaxException e) {
            String msg = e instanceof URISyntaxException ? "invalid index url" : "login failed";
            throw new LoginException(msg, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return LoginData.CovertData.buildCovertData(loginData, password);
    }

    protected LoginStatus sendLogin(LoginData.CovertData covertData) throws LoginException {
        LoginStatus loginStatus;
        block11: {
            HttpPost httpPost;
            try {
                URIBuilder uriBuilder = this.urlManager.getLoginLink(this.domain);
                if (covertData.getUrlParams() != null) {
                    uriBuilder.setParameters(covertData.getUrlParams());
                }
                httpPost = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException e) {
                throw new LoginException("invalid login url", e);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(covertData.getRequestEntity(), Consts.UTF_8));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.context);
            try {
                loginStatus = this.getLoginStatusFromResp(response);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LoginException("IO error");
                }
            }
            response.close();
        }
        return loginStatus;
    }

    private LoginStatus getLoginStatusFromResp(CloseableHttpResponse response) {
        try {
            this.getResp(response);
        }
        catch (IOException ioException) {
            throw new ServiceException("io error", ioException);
        }
        catch (NotLoggedInException e) {
            return e.getStatus();
        }
        return LoginStatus.success();
    }

    @Override
    protected boolean isNeedLogin(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() != 302;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }
}

