/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.service.core.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import top.xcphoenix.jfjw.expection.NotLoggedInException;
import top.xcphoenix.jfjw.expection.ServiceException;
import top.xcphoenix.jfjw.model.user.UserBaseInfo;
import top.xcphoenix.jfjw.service.BaseService;
import top.xcphoenix.jfjw.service.core.UserInfoService;

public class UserInfoServiceImpl
extends BaseService
implements UserInfoService {
    @Override
    public UserBaseInfo getUserInfo() throws NotLoggedInException, ServiceException {
        UserBaseInfo userBaseInfo;
        block10: {
            HttpGet httpGet;
            try {
                URIBuilder uriBuilder = this.urlManager.getUserInfoApiLink(this.domain);
                httpGet = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException e) {
                throw new ServiceException("the user info url is invalid", e);
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.context);
            try {
                userBaseInfo = this.dealResp(response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("io error", e);
                }
            }
            response.close();
        }
        return userBaseInfo;
    }

    private UserBaseInfo dealResp(CloseableHttpResponse response) throws NotLoggedInException {
        UserBaseInfo info;
        String html;
        try {
            html = super.getResp(response);
        }
        catch (IOException e) {
            throw new ServiceException("io error", e);
        }
        try {
            info = this.getUserInfo(html);
        }
        catch (JSONException e) {
            throw new ServiceException("services error");
        }
        return info;
    }

    private UserBaseInfo getUserInfo(String json) throws JSONException {
        JSONObject jsonObject = JSON.parseObject((String)json);
        UserBaseInfo userBaseInfo = new UserBaseInfo();
        userBaseInfo.setAllData(jsonObject.getInnerMap());
        userBaseInfo.setStuCode(jsonObject.getString("xh"));
        userBaseInfo.setName(jsonObject.getString("xm"));
        userBaseInfo.setSex(jsonObject.getString("xbm"));
        userBaseInfo.setHomeTown(jsonObject.getString("jg"));
        userBaseInfo.setGrade(jsonObject.getIntValue("njdm_id"));
        userBaseInfo.setIClass(jsonObject.getString("bh_id"));
        userBaseInfo.setMajor(jsonObject.getString("zyh_id"));
        userBaseInfo.setFaculty(jsonObject.getString("zsjg_id"));
        userBaseInfo.setKind(jsonObject.getString("xslbdm"));
        return userBaseInfo;
    }
}

