/*
 * Decompiled with CFR 0.152.
 */
package top.xcphoenix.jfjw.util;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;

public class RsaUtil {
    private BigInteger n;
    private BigInteger e;

    public RsaUtil(String n, String e) {
        this.n = new BigInteger(n, 16);
        this.e = new BigInteger(e, 16);
    }

    public String rsaEncrypt(String pwd) {
        BigInteger r = this.rsaDoPublic(Objects.requireNonNull(RsaUtil.pkcs1pad2(pwd, this.n.bitLength() + 7 >> 3)));
        String sp = r.toString(16);
        if ((sp.length() & 1) != 0) {
            sp = "0" + sp;
        }
        return sp;
    }

    private BigInteger rsaDoPublic(BigInteger x) {
        return x.modPow(this.e, this.n);
    }

    private static BigInteger pkcs1pad2(String s, int n) {
        if (n < s.length() + 11) {
            System.err.println("Message too long for RSAEncoder");
            return null;
        }
        byte[] ba = new byte[n];
        int i = s.length() - 1;
        while (i >= 0 && n > 0) {
            int c;
            if ((c = s.codePointAt(i--)) < 128) {
                ba[--n] = new Byte(String.valueOf(c));
                continue;
            }
            Byte aByte = new Byte(String.valueOf(c & 0x3F | 0x80));
            ba[--n] = aByte;
            if (c < 2048) {
                ba[--n] = new Byte(String.valueOf(c >> 6 | 0xC0));
                continue;
            }
            ba[--n] = new Byte(String.valueOf(c >> 6 & 0x3F | 0x80));
            ba[--n] = new Byte(String.valueOf(c >> 12 | 0xE0));
        }
        ba[--n] = new Byte("0");
        byte[] temp = new byte[1];
        Random rdm = new Random(47L);
        while (n > 2) {
            temp[0] = new Byte("0");
            while (temp[0] == 0) {
                rdm.nextBytes(temp);
            }
            ba[--n] = temp[0];
        }
        ba[--n] = 2;
        ba[--n] = 0;
        return new BigInteger(ba);
    }
}

