/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.container;

import cn.hutool.core.collection.CollUtil;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;

public abstract class BaseNamespaceContainer<K, T>
implements Container {
    private static final Logger log = LoggerFactory.getLogger(BaseNamespaceContainer.class);

    @Override
    public void process(MultiValueMap<AssembleOperation, ?> operations) {
        if (CollUtil.isEmpty(operations)) {
            return;
        }
        MultiValueMap<String, K> namespacesAndKeys = this.getNamespaceAndKeyFromTargets(operations);
        if (CollUtil.isEmpty(namespacesAndKeys)) {
            return;
        }
        Map sources = ObjectUtils.trySupply(() -> this.getSources(namespacesAndKeys), e -> log.warn("\u5bb9\u5668[{}]\u83b7\u53d6\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff0c\u6570\u636e[{}]\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{this.getClass(), namespacesAndKeys, e.getMessage()}));
        if (CollUtil.isEmpty((Map)sources)) {
            return;
        }
        CollUtils.forEach(operations, (op, t) -> this.writeToTargets(sources, t, (AssembleOperation)op));
    }

    protected void writeToTargets(@Nonnull Map<String, Map<K, T>> sources, @CheckForNull Object target, @Nonnull AssembleOperation operation) {
        if (Objects.isNull(target)) {
            return;
        }
        Map<K, T> keyMap = sources.get(operation.getNamespace());
        if (CollUtil.isEmpty(keyMap)) {
            return;
        }
        Object key = operation.getAssembler().getKey(target, operation);
        Object source = keyMap.get(this.parseKey(key));
        if (Objects.isNull(source)) {
            return;
        }
        ObjectUtils.tryAction(() -> operation.getAssembler().execute(target, source, operation), x -> log.error("\u5b57\u6bb5[{}]\u5904\u7406\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)operation.getTargetProperty(), (Object)x.getMessage()));
    }

    @Nonnull
    protected abstract Map<String, Map<K, T>> getSources(@Nonnull MultiValueMap<String, K> var1);

    @Nonnull
    protected MultiValueMap<String, K> getNamespaceAndKeyFromTargets(@Nonnull MultiValueMap<AssembleOperation, ?> operations) {
        LinkedMultiValueMap results = new LinkedMultiValueMap();
        CollUtils.forEach(operations, (arg_0, arg_1) -> this.lambda$getNamespaceAndKeyFromTargets$5((MultiValueMap)results, arg_0, arg_1));
        return results;
    }

    @Nullable
    protected K parseKey(@Nullable Object key) {
        return (K)key;
    }

    private /* synthetic */ void lambda$getNamespaceAndKeyFromTargets$5(MultiValueMap results, AssembleOperation op, Object t) {
        Object key = op.getAssembler().getKey(t, op);
        K actualKey = this.parseKey(key);
        if (Objects.nonNull(actualKey)) {
            results.add((Object)op.getNamespace(), actualKey);
        }
    }
}

