/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import top.xiajibagao.crane.core.handler.CollectionOperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;

public class ArrayOperateHandler
extends CollectionOperateHandler
implements OperateHandler {
    public ArrayOperateHandler(OperateHandlerChain handlerChain) {
        super(handlerChain);
    }

    @Override
    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return ArrayUtil.isArray((Object)source);
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return ArrayUtil.isArray((Object)target);
    }

    @Override
    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source) || ArrayUtil.isEmpty((Object)source)) {
            return null;
        }
        return super.readFromSource(Arrays.asList((Object[])source), property, operation);
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (ArrayUtil.isNotEmpty((Object)target)) {
            super.writeToTarget(sourceData, Arrays.asList((Object[])target), property, operation);
        }
    }
}

