/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.ClassUtils;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;

public class CollectionOperateHandler
implements OperateHandler {
    private final OperateHandlerChain handlerChain;

    @Override
    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return ClassUtils.isAssignable(Collection.class, source.getClass());
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return ClassUtils.isAssignable(Collection.class, target.getClass());
    }

    @Override
    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (!property.hasResource()) {
            return source;
        }
        return this.parseCollection(source).stream().map(t -> this.handlerChain.readFromSource(t, property, operation)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (Objects.isNull(sourceData) || Objects.isNull(target)) {
            return;
        }
        Collection<Object> targetColl = this.parseCollection(target);
        targetColl.forEach(t -> this.handlerChain.writeToTarget(sourceData, t, property, operation));
    }

    private Collection<Object> parseCollection(Object data) {
        return (Collection)data;
    }

    public CollectionOperateHandler(OperateHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }
}

