/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.handler;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandler;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.helper.ExpressionUtils;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.Operation;

public class ExpressibleOperateHandlerChain
implements OperateHandlerChain {
    private final OperateHandlerChain handlerChain;
    private final Supplier<StandardEvaluationContext> contextFactory;

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public List<OperateHandler> handlers() {
        return this.handlerChain.handlers();
    }

    @Override
    public OperateHandlerChain addHandler(OperateHandler handler) {
        return this.handlerChain.addHandler(handler);
    }

    @Override
    public boolean sourceCanRead(Object source, AssembleProperty property, Operation operation) {
        return this.handlerChain.sourceCanRead(source, property, operation);
    }

    @Override
    public boolean targetCanWrite(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        return this.handlerChain.targetCanWrite(sourceData, target, property, operation);
    }

    @Override
    public Object readFromSource(Object source, AssembleProperty property, Operation operation) {
        return this.handlerChain.readFromSource(source, property, operation);
    }

    @Override
    public void writeToTarget(Object sourceData, Object target, AssembleProperty property, AssembleOperation operation) {
        if (CharSequenceUtil.isBlank((CharSequence)property.getExp())) {
            this.handlerChain.writeToTarget(sourceData, target, property, operation);
            return;
        }
        StandardEvaluationContext context = this.contextFactory.get();
        context.setVariable("target", target);
        context.setVariable("source", sourceData);
        context.setVariable("key", operation.getAssembler().getKey(target, operation));
        context.setVariable("src", (Object)property.getResource());
        context.setVariable("ref", (Object)property.getReference());
        sourceData = ExpressionUtils.execute(property.getExp(), (EvaluationContext)context, property.getExpType(), true);
        this.handlerChain.writeToTarget(sourceData, target, property, operation);
    }

    public OperateHandlerChain getHandlerChain() {
        return this.handlerChain;
    }

    public Supplier<StandardEvaluationContext> getContextFactory() {
        return this.contextFactory;
    }

    public ExpressibleOperateHandlerChain(OperateHandlerChain handlerChain, Supplier<StandardEvaluationContext> contextFactory) {
        this.handlerChain = handlerChain;
        this.contextFactory = contextFactory;
    }
}

