/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Consumer3;
import cn.hutool.core.stream.StreamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public final class CollUtils {
    private CollUtils() {
    }

    public static <T> Stream<T> of(Collection<T> source) {
        return CollUtil.defaultIfEmpty(source, Collections.emptyList()).stream();
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... targets) {
        return ObjectUtils.computeIfNotNull(targets, Arrays::asList, Collections.emptyList());
    }

    public static <T> boolean anyMatch(Collection<T> source, Predicate<T> predicate, boolean ifEmpty) {
        return CollUtil.isNotEmpty(source) ? source.stream().filter(Objects::nonNull).anyMatch(predicate) : ifEmpty;
    }

    @SafeVarargs
    public static <T> boolean anyMatch(Predicate<T> predicate, boolean ifEmpty, T ... targets) {
        return CollUtils.anyMatch(CollUtils.asList(targets), predicate, ifEmpty);
    }

    public static <T> boolean allMatch(Collection<T> source, Predicate<T> predicate, boolean ifEmpty) {
        return CollUtil.isNotEmpty(source) ? source.stream().filter(Objects::nonNull).allMatch(predicate) : ifEmpty;
    }

    @SafeVarargs
    public static <T> boolean allMatch(Predicate<T> predicate, boolean ifEmpty, T ... targets) {
        return CollUtils.anyMatch(CollUtils.asList(targets), predicate, ifEmpty);
    }

    public static <T> boolean noneMatch(Collection<T> source, Predicate<T> predicate, boolean ifEmpty) {
        return CollUtil.isNotEmpty(source) ? source.stream().filter(Objects::nonNull).noneMatch(predicate) : ifEmpty;
    }

    @SafeVarargs
    public static <T> boolean noneMatch(Predicate<T> predicate, boolean ifEmpty, T ... targets) {
        return CollUtils.noneMatch(CollUtils.asList(targets), predicate, ifEmpty);
    }

    @NonNull
    public static <S, T, C extends Collection<T>> C toCollection(@NonNull Collection<S> source, @NonNull Supplier<C> collFactory, @NonNull Function<S, T> mapper) {
        return (C)((Collection)source.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(collFactory)));
    }

    @NonNull
    public static <S, T> Set<T> toSet(Collection<S> source, @NonNull Function<S, T> mapper) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return CollUtils.toCollection(source, HashSet::new, mapper);
    }

    @NonNull
    public static <T> Set<T> toSet(Collection<T> source) {
        return CollUtils.toSet(source, Function.identity());
    }

    @NonNull
    public static <T> List<T> toList(Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        return CollUtils.toCollection(source, ArrayList::new, Function.identity());
    }

    public static Collection<?> adaptToCollection(Object target) {
        if (Objects.isNull(target)) {
            return Collections.emptyList();
        }
        if (target instanceof Collection) {
            return (Collection)target;
        }
        if (target instanceof Map) {
            return ((Map)target).entrySet();
        }
        if (target.getClass().isArray()) {
            return Arrays.asList((Object[])target);
        }
        return Collections.singletonList(target);
    }

    public static <T> void forEach(Iterable<T> source, Consumer<T> consumer) {
        if (CollUtil.isEmpty(source)) {
            return;
        }
        for (T t : source) {
            if (!Objects.nonNull(t)) continue;
            consumer.accept(t);
        }
    }

    public static <T> void flatForEach(Iterable<Iterable<T>> source, Consumer<T> consumer) {
        if (CollUtil.isEmpty(source)) {
            return;
        }
        StreamUtil.of(source).filter(CollUtil::isNotEmpty).flatMap(StreamUtil::of).filter(Objects::nonNull).forEach(consumer);
    }

    public static <T, R> void biForEach(Iterable<T> source1, Iterable<R> source2, BiConsumer<T, R> consumer) {
        if (CollUtil.isEmpty(source1) || CollUtil.isEmpty(source2)) {
            return;
        }
        for (T t : source1) {
            if (Objects.isNull(t)) continue;
            for (R r : source2) {
                if (Objects.isNull(r)) continue;
                consumer.accept(t, r);
            }
        }
    }

    public static <R, C, V> void forEach(Map<R, ? extends Map<C, V>> source, Consumer3<R, C, V> consumer) {
        if (CollUtil.isEmpty(source)) {
            return;
        }
        source.forEach((rowKey, colMap) -> colMap.forEach((colKey, val) -> consumer.accept(rowKey, colKey, val)));
    }

    public static <K, V> void forEach(Map<K, ? extends Collection<V>> source, BiConsumer<K, V> consumer) {
        if (CollUtil.isEmpty(source)) {
            return;
        }
        source.forEach((k, vs) -> vs.forEach(v -> {
            if (Objects.nonNull(k) && Objects.nonNull(v)) {
                consumer.accept(k, v);
            }
        }));
    }
}

