/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public class CounterSet<T> {
    private final Map<T, Integer> counter = new HashMap<T, Integer>();

    public Set<T> keySet() {
        return this.counter.keySet();
    }

    public <K> CounterSet<T> plusAll(Collection<K> targets, Function<K, T> mapping) {
        targets.stream().filter(Objects::nonNull).forEach(t -> this.plus(mapping.apply(t)));
        return this;
    }

    public CounterSet<T> plus(T target) {
        this.updateCount(target, count -> count + 1);
        return this;
    }

    public CounterSet<T> sub(T target) {
        this.updateCount(target, count -> count - 1);
        return this;
    }

    private void updateCount(T target, IntFunction<Integer> update) {
        Integer count = this.counter.get(target);
        Integer nextCount = ObjectUtils.computeIfNotNull(count, update::apply, -1);
        this.counter.put(target, nextCount);
    }

    public T getMax() {
        return this.counter.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    public T getMin() {
        return this.counter.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    public void foreachByAsc(ObjIntConsumer<T> consumer) {
        this.counter.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> consumer.accept(e.getKey(), (Integer)e.getValue()));
    }

    public void foreachByDesc(ObjIntConsumer<T> consumer) {
        this.counter.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).forEach(e -> consumer.accept(e.getKey(), (Integer)e.getValue()));
    }
}

