/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.lang.NonNull;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public class EnumDict {
    private final Map<String, EnumDictType<?>> nameCache = new HashMap();
    private final Map<Class<?>, EnumDictType<?>> classCache = new HashMap();
    private static final EnumDict INSTANCE = new EnumDict();

    public static EnumDict instance() {
        return INSTANCE;
    }

    public <T extends Enum<?>> void register(Class<T> targetType) {
        this.register(targetType, null, null);
    }

    public <T extends Enum<?>> void register(Class<T> targetType, String typeName, Function<T, String> itemNameGetter) {
        typeName = ObjectUtils.defaultIfNull(typeName, targetType.getSimpleName());
        EnumDictType type = new EnumDictType(targetType, typeName);
        List<EnumDictItem> targets = Arrays.stream(targetType.getEnumConstants()).map(item -> new EnumDictItem<Enum>(type, (Enum)item, ObjectUtils.defaultIfNull(itemNameGetter, Enum::name).apply((Enum)item))).collect(Collectors.toList());
        targets.forEach(type::addItem);
        this.nameCache.put(typeName, type);
        this.classCache.put(targetType, type);
    }

    public <T extends Enum<?>> EnumDictType<T> getType(String typeName) {
        return this.nameCache.get(typeName);
    }

    public <T extends Enum<?>> EnumDictType<T> getType(Class<T> enumClass) {
        return this.classCache.get(enumClass);
    }

    public <T extends Enum<?>> EnumDictItem<T> getItem(String typeName, String itemName) {
        EnumDictType<T> type = this.getType(typeName);
        return type == null ? null : type.get(itemName);
    }

    public <T extends Enum<?>> EnumDictItem<T> getItem(Class<T> enumClass, String itemName) {
        EnumDictType<T> type = this.getType(enumClass);
        return type == null ? null : type.get(itemName);
    }

    public <T extends Enum<?>> T getEnum(Class<T> enumClass, String itemName) {
        return (T)((Enum)Optional.ofNullable(this.getType(enumClass)).map(t -> t.get(itemName)).map(EnumDictItem::getTarget).orElse(null));
    }

    public <T extends Enum<?>> T getEnum(String typeName, String itemName) {
        return (T)((Enum)Optional.ofNullable(this.getType(typeName)).map(t -> t.get(itemName)).map(EnumDictItem::getTarget).orElse(null));
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Item {
        public String itemName() default "";

        public String typeName() default "";
    }

    public static class EnumDictItem<T extends Enum<?>>
    extends HashMap<String, Object> {
        private final EnumDictType<T> type;
        private final T target;
        private final String name;

        protected EnumDictItem(EnumDictType<T> type, T target, String name) {
            this.type = type;
            this.name = name;
            this.target = target;
            HashMap properties = new HashMap(BeanMap.create(target));
            properties.remove("declaringClass");
            this.putAll(properties);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumDictItem)) {
                return false;
            }
            EnumDictItem other = (EnumDictItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnumDictType<T> this$type = this.getType();
            EnumDictType<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            T this$target = this.getTarget();
            T other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumDictItem;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EnumDictType<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            T $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public EnumDictType<T> getType() {
            return this.type;
        }

        public T getTarget() {
            return this.target;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class EnumDictType<T extends Enum<?>> {
        private final Class<T> type;
        private final String name;
        private final Map<String, EnumDictItem<T>> nameCache;
        private final Map<Enum<?>, EnumDictItem<T>> enumCache;

        protected EnumDictType(Class<T> type, String name) {
            this.type = type;
            this.name = name;
            int len = ((Enum[])type.getEnumConstants()).length;
            this.nameCache = new HashMap<String, EnumDictItem<T>>(len);
            this.enumCache = new HashMap(len);
        }

        public EnumDictItem<T> get(@NonNull String itemName) {
            return this.nameCache.get(itemName);
        }

        public EnumDictItem<T> get(@NonNull Enum<?> target) {
            return this.enumCache.get(target);
        }

        public void addItem(EnumDictItem<T> item) {
            this.nameCache.put(item.getName(), item);
            this.enumCache.put((Enum<?>)item.getTarget(), item);
        }

        public Class<T> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, EnumDictItem<T>> getNameCache() {
            return this.nameCache;
        }

        public Map<Enum<?>, EnumDictItem<T>> getEnumCache() {
            return this.enumCache;
        }
    }
}

