/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MultiValueTableMap<R, C, V> {
    private final Map<R, MultiValueMap<C, V>> rowMap = new HashMap<R, MultiValueMap<C, V>>();

    public MultiValueMap<C, V> getColMap(R rowKey) {
        return this.rowMap.get(rowKey);
    }

    public void putVal(R rowKey, C colKey, V val) {
        this.getOrCreate(rowKey).add(colKey, val);
    }

    public void putValAll(R rowKey, C colKey, Collection<V> val) {
        if (CollUtil.isNotEmpty(val)) {
            MultiValueMap colMap = this.getOrCreate(rowKey);
            val.forEach(v -> colMap.add(colKey, v));
        }
    }

    public Map<R, MultiValueMap<C, V>> asMap() {
        return this.rowMap;
    }

    private MultiValueMap<C, V> getOrCreate(R rowKey) {
        return this.rowMap.computeIfAbsent(rowKey, rk -> new LinkedMultiValueMap());
    }
}

