/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public interface TableMap<R, C, V> {
    default public V getVal(R rowKey, C colKey) {
        Map<C, V> colMap = this.getColMap(rowKey);
        return Objects.isNull(colMap) ? null : (V)colMap.get(colKey);
    }

    default public V getValOrDefault(R rowKey, C colKey, V def) {
        Map<C, V> colMap = this.getColMap(rowKey);
        return (V)ObjectUtils.computeIfNotNull(colMap, cm -> cm.get(colKey), def);
    }

    public Map<C, V> getColMap(R var1);

    public boolean containsColMap(Object var1);

    default public boolean containsVal(R rowKey, C colKey) {
        Map<C, V> colMap = this.getColMap(rowKey);
        return !Objects.isNull(colMap) && colMap.containsKey(colKey);
    }

    public void putVal(R var1, C var2, V var3);

    default public void putVal(R rowKey, Map<C, V> map) {
        if (CollUtil.isNotEmpty(map)) {
            map.forEach((k, v) -> this.putVal(rowKey, k, v));
        }
    }

    public void putColMap(Map<R, Map<C, V>> var1);

    public Map<R, Map<C, V>> asMap();

    default public Set<R> rowKeySet() {
        return this.asMap().keySet();
    }

    default public V computeIfAbsent(R rowKey, C colKey, BiFunction<R, C, V> compute) {
        V v = this.getVal(rowKey, colKey);
        if (Objects.isNull(v)) {
            v = compute.apply(rowKey, colKey);
            this.putVal(rowKey, colKey, v);
        }
        return v;
    }

    default public List<V> values() {
        return this.asMap().values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

