/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.operator;

import cn.hutool.core.collection.CollUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import top.xiajibagao.crane.core.exception.CraneException;
import top.xiajibagao.crane.core.handler.interfaces.OperateHandlerChain;
import top.xiajibagao.crane.core.operator.interfaces.Assembler;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.EmptyAssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;

public class BeanReflexAssembler
implements Assembler {
    private final OperateHandlerChain handlerChain;

    @Override
    public void execute(Object target, Object source, AssembleOperation operation) {
        if (Objects.isNull(target) || Objects.isNull(source)) {
            return;
        }
        this.checkType(target, operation);
        List properties = (List)CollUtil.defaultIfEmpty(operation.getProperties(), Collections.singletonList(EmptyAssembleProperty.instance()));
        for (AssembleProperty property : properties) {
            Object sourceData = this.handlerChain.readFromSource(source, property, operation);
            if (Objects.isNull(sourceData)) {
                return;
            }
            this.handlerChain.writeToTarget(sourceData, target, property, operation);
        }
    }

    @Override
    public Object getKey(Object target, AssembleOperation operation) {
        this.checkType(target, operation);
        return this.handlerChain.readFromSource(target, new BeanAssembleProperty(null, operation.getTargetProperty().getName(), "", Void.class), operation);
    }

    private void checkType(Object target, AssembleOperation operation) {
        CraneException.throwIfFalse(operation.getOwner().getTargetClass().isAssignableFrom(target.getClass()), "\u64cd\u4f5c\u914d\u7f6e\u7c7b\u578b\u4e3a[{}]\uff0c\u4f46\u5f85\u5904\u7406\u6570\u636e\u7c7b\u578b\u4e3a[{}]", operation.getOwner().getTargetClass(), target.getClass());
    }

    public OperateHandlerChain getHandlerChain() {
        return this.handlerChain;
    }

    public BeanReflexAssembler(OperateHandlerChain handlerChain) {
        this.handlerChain = handlerChain;
    }
}

