/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.parser;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.FuncUtils;
import top.xiajibagao.crane.core.helper.ReflexUtils;
import top.xiajibagao.crane.core.helper.SFunc;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.BeanAssembleOperation;
import top.xiajibagao.crane.core.parser.BeanAssembleProperty;
import top.xiajibagao.crane.core.parser.BeanDisassembleOperation;
import top.xiajibagao.crane.core.parser.BeanOperationConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.AssembleProperty;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class OperateConfigurationAssistant<T> {
    private final OperationConfiguration configuration;

    public static <T> OperateConfigurationAssistant<T> basedOn(OperationConfiguration configuration) {
        return new OperateConfigurationAssistant<T>(configuration);
    }

    public static <T> OperateConfigurationAssistant<T> basedOnBeanOperationConfiguration(GlobalConfiguration globalConfiguration, Class<T> targetClass, OperatorFactory operatorFactory) {
        return new OperateConfigurationAssistant<T>(new BeanOperationConfiguration(globalConfiguration, targetClass, operatorFactory, new ArrayList<AssembleOperation>(), new ArrayList<DisassembleOperation>()));
    }

    public AssembleOperationBuilder<T> buildAssembler(String keyProperty, @NonNull Container container) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        Field keyField = ReflexUtils.findField(this.configuration.getTargetClass(), keyProperty);
        Assert.notNull((Object)keyField, (String)"\u7c7b[{}]\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027[{}]", (Object[])new Object[]{this.configuration.getTargetClass(), keyProperty});
        return new AssembleOperationBuilder(this, keyField, container);
    }

    public AssembleOperationBuilder<T> buildAssembler(@NonNull SFunc<T, ?> keyFunc, @NonNull Container container) {
        if (keyFunc == null) {
            throw new NullPointerException("keyFunc is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        return this.buildAssembler(FuncUtils.getPropertyName(keyFunc), container);
    }

    public DisassembleOperationBuilder<T> buildDisassembler(@NonNull String property, @NonNull OperationConfiguration targetOperateConfiguration) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (targetOperateConfiguration == null) {
            throw new NullPointerException("targetOperateConfiguration is marked non-null but is null");
        }
        Field keyField = ReflexUtils.findField(this.configuration.getTargetClass(), property);
        Assert.notNull((Object)keyField, (String)"\u7c7b[{}]\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027[{}]", (Object[])new Object[]{this.configuration.getTargetClass(), property});
        return new DisassembleOperationBuilder(this, keyField, targetOperateConfiguration);
    }

    public DisassembleOperationBuilder<T> buildDisassembler(@NonNull SFunc<T, ?> propertyFunc, @NonNull OperationConfiguration targetOperateConfiguration) {
        if (propertyFunc == null) {
            throw new NullPointerException("propertyFunc is marked non-null but is null");
        }
        if (targetOperateConfiguration == null) {
            throw new NullPointerException("targetOperateConfiguration is marked non-null but is null");
        }
        return this.buildDisassembler(FuncUtils.getPropertyName(propertyFunc), targetOperateConfiguration);
    }

    private OperateConfigurationAssistant(OperationConfiguration configuration) {
        this.configuration = configuration;
    }

    public OperationConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class AssembleOperationBuilder<T> {
        private final OperateConfigurationAssistant<T> builder;
        private final Field targetField;
        private final Container container;
        private final Set<String> aliases = new HashSet<String>();
        private final List<AssembleProperty> properties = new ArrayList<AssembleProperty>();
        private String namespace = "";
        private int order = 0;

        public AssembleOperationBuilder<T> aliases(String ... aliases) {
            if (ArrayUtil.isNotEmpty((Object[])aliases)) {
                this.aliases.addAll(Arrays.asList(aliases));
            }
            return this;
        }

        public AssembleOperationBuilder<T> sort(int order) {
            this.order = order;
            return this;
        }

        public AssembleOperationBuilder<T> namespace(String namespace) {
            this.namespace = CharSequenceUtil.blankToDefault((CharSequence)namespace, (String)"");
            return this;
        }

        public AssembleOperationBuilder<T> properties(Collection<AssembleProperty> properties) {
            if (CollUtil.isNotEmpty(properties)) {
                this.properties.addAll(properties);
            }
            return this;
        }

        public AssembleOperationBuilder<T> property(String resource, String reference) {
            return this.property(resource, reference, "", Void.class);
        }

        public AssembleOperationBuilder<T> property(String resource, String reference, String exp, Class<?> expType) {
            this.properties.add(new BeanAssembleProperty(CharSequenceUtil.blankToDefault((CharSequence)reference, (String)""), CharSequenceUtil.blankToDefault((CharSequence)resource, (String)""), exp, expType));
            return this;
        }

        public AssembleOperationBuilder<T> property(String resource, SFunc<T, ?> reference) {
            return this.property(resource, FuncUtils.getPropertyName(reference));
        }

        public <S> AssembleOperationBuilder<T> property(SFunc<S, ?> resource, SFunc<T, ?> reference) {
            return this.property(FuncUtils.getPropertyName(resource), FuncUtils.getPropertyName(reference));
        }

        public AssembleOperationBuilder<T> onlyRefProperty(SFunc<T, ?> reference) {
            return this.property("", FuncUtils.getPropertyName(reference));
        }

        public AssembleOperationBuilder<T> onlyRefProperty(String reference) {
            return this.property("", reference);
        }

        public <S> AssembleOperationBuilder<T> onlySrcProperty(SFunc<S, ?> resource) {
            return this.property(FuncUtils.getPropertyName(resource), "");
        }

        public AssembleOperationBuilder<T> onlySrcProperty(String resource) {
            return this.property(resource, "");
        }

        public OperateConfigurationAssistant<T> build() {
            ((OperateConfigurationAssistant)this.builder).configuration.getAssembleOperations().add(new BeanAssembleOperation(this.order, ((OperateConfigurationAssistant)this.builder).configuration, this.targetField, this.aliases, this.namespace, this.container, ((OperateConfigurationAssistant)this.builder).configuration.getOperatorFactory().getAssembler(), this.properties));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> getBuilder() {
            return this.builder;
        }

        public Field getTargetField() {
            return this.targetField;
        }

        public Container getContainer() {
            return this.container;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public List<AssembleProperty> getProperties() {
            return this.properties;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public int getOrder() {
            return this.order;
        }

        public AssembleOperationBuilder(OperateConfigurationAssistant<T> builder, Field targetField, Container container) {
            this.builder = builder;
            this.targetField = targetField;
            this.container = container;
        }
    }

    public static class DisassembleOperationBuilder<T> {
        private final OperateConfigurationAssistant<T> builder;
        private final Field targetField;
        private int sort = 0;
        private final Set<String> aliases = new HashSet<String>();
        private final OperationConfiguration targetOperateConfiguration;

        public DisassembleOperationBuilder<T> aliases(String ... aliases) {
            if (ArrayUtil.isNotEmpty((Object[])aliases)) {
                this.aliases.addAll(Arrays.asList(aliases));
            }
            return this;
        }

        public DisassembleOperationBuilder<T> sort(int sort) {
            this.sort = sort;
            return this;
        }

        public OperateConfigurationAssistant<T> build(Function<DisassembleOperationBuilder<T>, DisassembleOperation> operationFactory) {
            ((OperateConfigurationAssistant)this.builder).configuration.getDisassembleOperations().add(operationFactory.apply(this));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> build() {
            ((OperateConfigurationAssistant)this.builder).configuration.getDisassembleOperations().add(new BeanDisassembleOperation(this.sort, ((OperateConfigurationAssistant)this.builder).configuration, ((OperateConfigurationAssistant)this.builder).configuration.getOperatorFactory().getDisassembler(), this.targetOperateConfiguration, this.targetField, this.aliases));
            return this.builder;
        }

        public OperateConfigurationAssistant<T> getBuilder() {
            return this.builder;
        }

        public Field getTargetField() {
            return this.targetField;
        }

        public int getSort() {
            return this.sort;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }

        public OperationConfiguration getTargetOperateConfiguration() {
            return this.targetOperateConfiguration;
        }

        public DisassembleOperationBuilder(OperateConfigurationAssistant<T> builder, Field targetField, OperationConfiguration targetOperateConfiguration) {
            this.builder = builder;
            this.targetField = targetField;
            this.targetOperateConfiguration = targetOperateConfiguration;
        }
    }
}

