/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.cache;

import java.util.Objects;
import org.springframework.lang.NonNull;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class CacheConfigurationParserWrapper<T extends OperationConfiguration>
implements OperateConfigurationParser<T> {
    private final ConfigurationCache configurationCache;
    private final OperateConfigurationParser<T> configurationParser;

    protected String getNamespace() {
        return this.configurationParser.getClass().getName();
    }

    @Override
    public T parse(@NonNull Class<?> targetClass, @NonNull OperatorFactory operatorFactory) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(operatorFactory);
        return (T)this.configurationCache.getOrCached(this.getNamespace(), operatorFactory.getClass(), targetClass, () -> this.configurationParser.parse(targetClass, operatorFactory));
    }

    public CacheConfigurationParserWrapper(ConfigurationCache configurationCache, OperateConfigurationParser<T> configurationParser) {
        this.configurationCache = configurationCache;
        this.configurationParser = configurationParser;
    }
}

