/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.container;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.crane.core.annotation.MappingType;
import top.xiajibagao.crane.core.annotation.MethodSourceBean;
import top.xiajibagao.crane.core.container.BaseNamespaceContainer;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.helper.BeanProperty;
import top.xiajibagao.crane.core.helper.ReflexUtils;

public class MethodSourceContainer
extends BaseNamespaceContainer<Object, Object>
implements Container {
    public final Map<String, MethodSource> methodCache = new HashMap<String, MethodSource>();

    public void register(Object methodSourceBean) {
        if (Objects.isNull(methodSourceBean)) {
            return;
        }
        Class<?> targetClass = methodSourceBean.getClass();
        if (this.parseClassAnnotation(methodSourceBean, targetClass)) {
            return;
        }
        this.parseMethodAnnotations(methodSourceBean, targetClass);
    }

    private boolean parseClassAnnotation(Object methodSourceBean, Class<?> targetClass) {
        MethodSourceBean.Method[] classMethods;
        MethodSourceBean annotation = (MethodSourceBean)AnnotatedElementUtils.findMergedAnnotation(targetClass, MethodSourceBean.class);
        if (Objects.isNull(annotation)) {
            return true;
        }
        for (MethodSourceBean.Method classMethod : classMethods = annotation.methods()) {
            Method method;
            if (CharSequenceUtil.isBlank((CharSequence)classMethod.name()) || !Objects.nonNull(method = ReflexUtils.findMethod(targetClass, classMethod.name(), true, classMethod.returnType(), classMethod.paramTypes()))) continue;
            this.checkMethod(method, classMethod.namespace());
            ReflexUtils.findProperty(classMethod.sourceType(), classMethod.sourceKey()).ifPresent(property -> {
                MethodSource cache = new MethodSource(classMethod.mappingType(), methodSourceBean, targetClass, classMethod.namespace(), method, (BeanProperty)property);
                this.methodCache.put(classMethod.namespace(), cache);
            });
        }
        return false;
    }

    private void parseMethodAnnotations(Object methodSourceBean, Class<?> targetClass) {
        List<Method> annotatedMethods = Stream.of(targetClass.getDeclaredMethods()).filter(m -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, MethodSourceBean.Method.class)).collect(Collectors.toList());
        annotatedMethods.forEach(proxyMethod -> {
            Method actualMethod = AopUtils.getMostSpecificMethod((Method)proxyMethod, (Class)targetClass);
            MethodSourceBean.Method annotation = (MethodSourceBean.Method)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)actualMethod, MethodSourceBean.Method.class);
            if (Objects.isNull(annotation)) {
                return;
            }
            this.checkMethod((Method)proxyMethod, annotation.namespace());
            ReflexUtils.findProperty(annotation.sourceType(), annotation.sourceKey()).ifPresent(pc -> {
                MethodSource method = new MethodSource(annotation.mappingType(), methodSourceBean, targetClass, annotation.namespace(), (Method)proxyMethod, (BeanProperty)pc);
                this.methodCache.put(annotation.namespace(), method);
            });
        });
    }

    private void checkMethod(Method declaredMethod, String containerName) {
        Assert.isTrue((!this.methodCache.containsKey(containerName) ? 1 : 0) != 0, (String)("\u5bb9\u5668\u65b9\u6cd5\u5df2\u7ecf\u88ab\u6ce8\u518c: " + containerName));
        Assert.isTrue((declaredMethod.getParameterTypes().length == 1 && ClassUtils.isAssignable(Collection.class, declaredMethod.getParameterTypes()[0]) ? 1 : 0) != 0, (String)("\u5bb9\u5668\u65b9\u6cd5\u6709\u4e14\u4ec5\u80fd\u6709\u4e00\u4e2aCollection\u7c7b\u578b\u7684\u53c2\u6570: " + Arrays.asList(declaredMethod.getParameterTypes())));
        Assert.isTrue((boolean)ClassUtils.isAssignable(Collection.class, declaredMethod.getReturnType()), (String)("\u5bb9\u5668\u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aCollection\u7c7b\u578b: " + declaredMethod.getReturnType()));
    }

    @Override
    @Nonnull
    protected Map<String, Map<Object, Object>> getSources(@Nonnull MultiValueMap<String, Object> namespaceAndKeys) {
        HashMap<String, Map<Object, Object>> results = new HashMap<String, Map<Object, Object>>(namespaceAndKeys.size());
        namespaceAndKeys.forEach((namespace, keys) -> {
            MethodSource method = this.methodCache.get(namespace);
            if (Objects.isNull(method)) {
                return;
            }
            Collection<Object> sources = method.getSources((List<Object>)keys);
            if (CollUtil.isEmpty(sources)) {
                return;
            }
            results.put((String)namespace, method.getMappingType().mapping(sources, method::getSourceKeyPropertyValue));
        });
        return results;
    }

    public static class MethodSource {
        private final MappingType mappingType;
        private final Object target;
        private final Class<?> targetClass;
        private final String containerName;
        private final Method sourceGetter;
        private final BeanProperty sourceKeyProperty;

        public Collection<Object> getSources(List<Object> keys) {
            Collection<Object> params = keys;
            if (Objects.equals(this.sourceGetter.getParameterTypes()[0], Set.class)) {
                params = new HashSet<Object>(keys);
            }
            return (Collection)ReflectionUtils.invokeMethod((Method)this.sourceGetter, (Object)this.target, (Object[])new Object[]{params});
        }

        public Object getSourceKeyPropertyValue(Object source) {
            return ReflectionUtils.invokeMethod((Method)this.sourceKeyProperty.getter(), (Object)source);
        }

        public MethodSource(MappingType mappingType, Object target, Class<?> targetClass, String containerName, Method sourceGetter, BeanProperty sourceKeyProperty) {
            this.mappingType = mappingType;
            this.target = target;
            this.targetClass = targetClass;
            this.containerName = containerName;
            this.sourceGetter = sourceGetter;
            this.sourceKeyProperty = sourceKeyProperty;
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public String getContainerName() {
            return this.containerName;
        }
    }
}

