/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.executor;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.springframework.util.CollectionUtils;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.MultiValueTableMap;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public abstract class AbstractOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration) {
        if (CollUtil.isEmpty(targets) || Objects.isNull(configuration)) {
            return;
        }
        List<Object> targetsList = StreamSupport.stream(targets.spliterator(), false).collect(Collectors.toList());
        MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations = new MultiValueTableMap<Container, AssembleOperation, Object>();
        this.collectOperations(targetsList, configuration, pendingOperations);
        this.execute(configuration.getGlobalConfiguration(), pendingOperations);
    }

    private void collectOperations(Collection<Object> targets, OperationConfiguration configuration, MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        if (CollectionUtils.isEmpty(targets)) {
            return;
        }
        this.processAssembleOperations(targets, configuration, pendingOperations);
        this.processDisassembleOperations(targets, configuration, pendingOperations);
    }

    protected abstract void execute(@Nonnull GlobalConfiguration var1, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> var2);

    protected void processAssembleOperations(@Nonnull Collection<Object> targets, @Nonnull OperationConfiguration configuration, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        List<AssembleOperation> operations = configuration.getAssembleOperations();
        if (CollectionUtils.isEmpty(operations)) {
            return;
        }
        operations.forEach(op -> pendingOperations.putValAll(op.getContainer(), (AssembleOperation)op, targets));
    }

    protected void processDisassembleOperations(@Nonnull Collection<?> targets, @Nonnull OperationConfiguration configuration, @Nonnull MultiValueTableMap<Container, AssembleOperation, Object> pendingOperations) {
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            Collection nestedPropertyValues = targets.stream().map(t -> operation.getDisassembler().execute(t, operation)).flatMap(Collection::stream).collect(Collectors.toList());
            OperationConfiguration operationConfiguration = operation.getTargetOperateConfiguration();
            this.collectOperations(nestedPropertyValues, operationConfiguration, pendingOperations);
        }
    }
}

