/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.executor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.stream.StreamUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import top.xiajibagao.crane.core.container.Container;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CounterSet;
import top.xiajibagao.crane.core.parser.interfaces.AssembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.DisassembleOperation;
import top.xiajibagao.crane.core.parser.interfaces.GlobalConfiguration;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class SequentialOperationExecutor
implements OperationExecutor {
    @Override
    public void execute(Iterable<?> targets, OperationConfiguration configuration) {
        if (CollUtil.isEmpty(targets) || Objects.isNull(configuration)) {
            return;
        }
        List<Object> targetsList = StreamUtil.of(targets).collect(Collectors.toList());
        MultiValueMap<OperationConfiguration, Object> collectedConfigurations = this.collectOperationConfigurations(targetsList, configuration, (MultiValueMap<OperationConfiguration, Object>)new LinkedMultiValueMap());
        this.execute(configuration.getGlobalConfiguration(), collectedConfigurations);
    }

    protected void execute(@Nonnull GlobalConfiguration globalConfiguration, @Nonnull MultiValueMap<OperationConfiguration, Object> collectedConfigurations) {
        Set buckets = collectedConfigurations.entrySet().stream().filter(e -> CollUtil.isNotEmpty(((OperationConfiguration)e.getKey()).getAssembleOperations())).map(e -> new Bucket(((OperationConfiguration)e.getKey()).getAssembleOperations(), (List)e.getValue())).peek(b -> Collections.sort(b.getOperations())).collect(Collectors.toSet());
        LinkedMultiValueMap batch = new LinkedMultiValueMap();
        while (CollUtil.isNotEmpty(buckets)) {
            Container maxContainer = (Container)new CounterSet<Object>().plusAll(buckets, Bucket::peekContainerOfFirstOperation).getMax();
            List matchedOperation = buckets.stream().map(b -> b.getOperations(maxContainer)).filter(Bucket::isNotEmpty).collect(Collectors.toList());
            batch.put((Object)maxContainer, matchedOperation);
            buckets = buckets.stream().filter(Bucket::isNotEmpty).collect(Collectors.toSet());
        }
        batch.forEach((container, bucketList) -> {
            List targets = bucketList.stream().map(Bucket::getTargets).flatMap(Collection::stream).collect(Collectors.toList());
            List<AssembleOperation> operations = bucketList.stream().map(Bucket::getOperations).flatMap(Collection::stream).collect(Collectors.toList());
            LinkedMultiValueMap processData = new LinkedMultiValueMap();
            operations.forEach(arg_0 -> SequentialOperationExecutor.lambda$null$4((MultiValueMap)processData, targets, arg_0));
            container.process((MultiValueMap<AssembleOperation, ?>)processData);
        });
    }

    @Nonnull
    protected MultiValueMap<OperationConfiguration, Object> collectOperationConfigurations(@Nonnull List<Object> targets, @Nonnull OperationConfiguration configuration, @Nonnull MultiValueMap<OperationConfiguration, Object> collectedConfigurations) {
        if (CollectionUtils.isEmpty(targets)) {
            return collectedConfigurations;
        }
        targets.forEach(t -> collectedConfigurations.add((Object)configuration, t));
        List<DisassembleOperation> disassembleOperations = configuration.getDisassembleOperations();
        if (CollectionUtils.isEmpty(disassembleOperations)) {
            return collectedConfigurations;
        }
        for (DisassembleOperation operation : disassembleOperations) {
            List<Object> nestedPropertyValues = targets.stream().map(t -> operation.getDisassembler().execute(t, operation)).flatMap(Collection::stream).collect(Collectors.toList());
            OperationConfiguration operationConfiguration = operation.getTargetOperateConfiguration();
            this.collectOperationConfigurations(nestedPropertyValues, operationConfiguration, collectedConfigurations);
        }
        return collectedConfigurations;
    }

    private static /* synthetic */ void lambda$null$4(MultiValueMap processData, List targets, AssembleOperation op) {
        processData.addAll((Object)op, targets);
    }

    private static class Bucket {
        private final List<AssembleOperation> operations;
        private final List<Object> targets;

        public Container peekContainerOfFirstOperation() {
            return this.isEmpty() ? null : ((AssembleOperation)CollUtil.getFirst(this.operations)).getContainer();
        }

        public Bucket getOperations(Container container) {
            AssembleOperation curr;
            ArrayList<AssembleOperation> matched = new ArrayList<AssembleOperation>();
            Iterator<AssembleOperation> iterator = this.operations.iterator();
            while (iterator.hasNext() && Objects.equals((curr = iterator.next()).getContainer(), container)) {
                matched.add(curr);
                iterator.remove();
            }
            return new Bucket(matched, this.targets);
        }

        public boolean isEmpty() {
            return CollectionUtils.isEmpty(this.operations);
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }

        public Bucket(List<AssembleOperation> operations, List<Object> targets) {
            this.operations = operations;
            this.targets = targets;
        }

        public List<AssembleOperation> getOperations() {
            return this.operations;
        }

        public List<Object> getTargets() {
            return this.targets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket other = (Bucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AssembleOperation> this$operations = this.getOperations();
            List<AssembleOperation> other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            List<Object> this$targets = this.getTargets();
            List<Object> other$targets = other.getTargets();
            return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bucket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AssembleOperation> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            List<Object> $targets = this.getTargets();
            result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
            return result;
        }

        public String toString() {
            return "SequentialOperationExecutor.Bucket(operations=" + this.getOperations() + ", targets=" + this.getTargets() + ")";
        }
    }
}

