/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import top.xiajibagao.crane.core.helper.TableMap;

public class BaseTableMap<R, C, V>
implements TableMap<R, C, V> {
    private final Supplier<Map<C, V>> colMapFactory;
    private final Map<R, Map<C, V>> rowMap;

    public BaseTableMap(@Nonnull Supplier<Map<R, Map<C, V>>> rowMapFactory, @Nonnull Supplier<Map<C, V>> colMapFactory) {
        this.colMapFactory = colMapFactory;
        this.rowMap = rowMapFactory.get();
    }

    public BaseTableMap(@Nonnull Supplier<Map<C, V>> colMapFactory) {
        this.colMapFactory = colMapFactory;
        this.rowMap = new HashMap<R, Map<C, V>>();
    }

    public BaseTableMap() {
        this(HashMap::new, HashMap::new);
    }

    @Override
    public Map<C, V> getColMap(R rowKey) {
        return this.rowMap.get(rowKey);
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map colMap = this.rowMap.get(rowKey);
        return Objects.nonNull(colMap) ? colMap : this.rowMap.computeIfAbsent(rowKey, rk -> this.colMapFactory.get());
    }

    @Override
    public boolean containsColMap(Object rowKey) {
        return this.rowMap.containsKey(rowKey);
    }

    @Override
    public void putVal(R rowKey, C colKey, V val) {
        Map<C, V> colMap = this.getOrCreate(rowKey);
        colMap.put(colKey, val);
    }

    @Override
    public void putColMap(Map<R, Map<C, V>> map) {
        if (CollUtil.isNotEmpty(map)) {
            this.rowMap.putAll(map);
        }
    }

    @Override
    public Map<R, Map<C, V>> asMap() {
        return this.rowMap;
    }
}

