/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;

public class BeanProperty {
    private final Class<?> targetClass;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public Object getValue(Object target) {
        return ObjectUtils.computeIfNotNull(target, t -> ReflectionUtils.invokeMethod((Method)this.getter, (Object)t));
    }

    public void setValue(Object target, Object value) {
        ReflectionUtils.invokeMethod((Method)this.setter, (Object)target, (Object[])new Object[]{value});
    }

    public BeanProperty(Class<?> targetClass, Field field, Method getter, Method setter) {
        this.targetClass = targetClass;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public Class<?> targetClass() {
        return this.targetClass;
    }

    public Field field() {
        return this.field;
    }

    public Method getter() {
        return this.getter;
    }

    public Method setter() {
        return this.setter;
    }
}

