/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import top.xiajibagao.crane.core.annotation.ConfigOption;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class ConfigOptionAnnotationProcessor<T extends AnnotatedElement> {
    private final BeanFactory beanFactory;
    private final ConfigurationCache configurationCache;

    public void process(T annotatedElement, Object target) {
        ConfigOption annotation = this.parseAnnotation((AnnotatedElement)annotatedElement);
        if (Objects.isNull(annotation)) {
            return;
        }
        Class<Void> targetClass = this.getTargetClass(annotation, annotatedElement, target);
        if (targetClass.isAssignableFrom(Void.TYPE)) {
            return;
        }
        OperateConfigurationParser parser = (OperateConfigurationParser)this.beanFactory.getBean(annotation.parser());
        OperatorFactory operatorFactory = (OperatorFactory)this.beanFactory.getBean(annotation.operatorFactory());
        OperationConfiguration configuration = this.configurationCache.getOrCached(this.getNamespace(parser), operatorFactory.getClass(), targetClass, () -> parser.parse(targetClass, operatorFactory));
        OperationExecutor executor = (OperationExecutor)this.beanFactory.getBean(annotation.executor());
        executor.execute(CollUtils.adaptToCollection(target), configuration);
    }

    protected String getNamespace(OperateConfigurationParser<OperationConfiguration> parser) {
        return parser.getClass().getName();
    }

    protected ConfigOption parseAnnotation(AnnotatedElement annotatedElement) {
        return Objects.isNull(annotatedElement) ? null : (ConfigOption)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, ConfigOption.class);
    }

    protected Class<?> getTargetClass(ConfigOption annotation, T annotatedElement, Object target) {
        return annotation.value();
    }

    public ConfigOptionAnnotationProcessor(BeanFactory beanFactory, ConfigurationCache configurationCache) {
        this.beanFactory = beanFactory;
        this.configurationCache = configurationCache;
    }
}

