/*
 * Decompiled with CFR 0.152.
 */
package top.xiajibagao.crane.core.helper;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Objects;
import top.xiajibagao.crane.core.cache.ConfigurationCache;
import top.xiajibagao.crane.core.executor.OperationExecutor;
import top.xiajibagao.crane.core.helper.CollUtils;
import top.xiajibagao.crane.core.helper.ObjectUtils;
import top.xiajibagao.crane.core.operator.interfaces.OperatorFactory;
import top.xiajibagao.crane.core.parser.interfaces.OperateConfigurationParser;
import top.xiajibagao.crane.core.parser.interfaces.OperationConfiguration;

public class OperateTemplate {
    private final ConfigurationCache configurationCache;
    private final OperatorFactory defaultOperatorFactory;
    private final OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser;
    private final OperationExecutor defaultOperationExecutor;

    public void process(Object target, OperationConfiguration configuration) {
        this.process(target, configuration, this.defaultOperationExecutor);
    }

    public void process(Object target, OperationConfiguration configuration, OperationExecutor executor) {
        executor.execute(CollUtils.adaptToCollection(target), configuration);
    }

    public void process(Object target, OperatorFactory factory, OperateConfigurationParser<? extends OperationConfiguration> parser, OperationExecutor executor) {
        Collection<?> targets = CollUtils.adaptToCollection(target);
        if (CollUtil.isEmpty(targets)) {
            return;
        }
        Class targetClass = ObjectUtils.computeIfNotNull(CollUtil.getFirst(targets), Object::getClass);
        if (Objects.isNull(targetClass)) {
            return;
        }
        OperationConfiguration configuration = this.configurationCache.getOrCached(parser.getClass().getName(), factory.getClass(), targetClass, () -> parser.parse(targetClass, factory));
        executor.execute(targets, configuration);
    }

    public void process(Object target, OperatorFactory factory, OperateConfigurationParser<? extends OperationConfiguration> parser) {
        this.process(target, factory, parser, this.defaultOperationExecutor);
    }

    public void process(Object target, OperatorFactory factory) {
        this.process(target, factory, this.defaultOperateConfigurationParser, this.defaultOperationExecutor);
    }

    public void process(Object target) {
        this.process(target, this.defaultOperatorFactory, this.defaultOperateConfigurationParser, this.defaultOperationExecutor);
    }

    public OperateTemplate(ConfigurationCache configurationCache, OperatorFactory defaultOperatorFactory, OperateConfigurationParser<? extends OperationConfiguration> defaultOperateConfigurationParser, OperationExecutor defaultOperationExecutor) {
        this.configurationCache = configurationCache;
        this.defaultOperatorFactory = defaultOperatorFactory;
        this.defaultOperateConfigurationParser = defaultOperateConfigurationParser;
        this.defaultOperationExecutor = defaultOperationExecutor;
    }
}

